% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistHistBeta}
\alias{PlotDistHistBeta}
\title{Plot distribution details as a histogram plus matching beta}
\usage{
PlotDistHistBeta(frm, xvar, title, ..., binwidth = NULL, bins = 30,
  hist_color = "darkgray", beta_color = "blue", mean_color = "blue",
  sd_color = "darkgray")
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{force later arguments to bind by name}

\item{binwidth}{passed to geom_histogram(). If passed in, overrides bins.}

\item{bins}{passed to geom_histogram(). Default: 30}

\item{hist_color}{color of empirical histogram}

\item{beta_color}{color of matching theoretical beta}

\item{mean_color}{color of mean line}

\item{sd_color}{color of 1-standard devation lines (can be NULL)}
}
\value{
ggplot2 plot
}
\description{
Compares empirical data to a beta distribution with the same mean and standard deviation.
}
\details{
Plots the histogram of the empirical distribution and the density of the matching beta distribution.
Also plots the mean and plus/minus one standard deviation.

The number of bins for the histogram defaults to 30.
The binwidth can also be passed in instead of the number of bins.
}
\examples{

set.seed(52523)
d <- data.frame(wt=rbeta(100,shape1=0.5,shape2=0.5))
PlotDistHistBeta(d,'wt','example')

# no sd lines
PlotDistHistBeta(d,'wt','example', sd_color=NULL)
}
