% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradcols.R
\name{gradcols}
\alias{gradcols}
\title{Get colors for plots}
\usage{
gradcols(col_vec = NULL)
}
\arguments{
\item{col_vec}{chr string of plot colors to use, typically passed to \code{\link[ggplot2]{scale_colour_gradientn}} for shading. Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}
}
\value{
A character vector of colors in hexidecimal notation.
}
\description{
Gets colors used for WRTDS plots
}
\details{
This is a convenience function for retrieving a color palette that is used by most of the plotting functions.   Palettes from RColorBrewer will use the maximum number of colors.  The default palette is 'Spectral'.
}
\examples{

## defaults
gradcols()

## another RColorBrewer palette
gradcols('Pastel2')

## a silly example
gradcols(rainbow(7))
}
\seealso{
\code{\link{dynaplot}}, \code{\link{gridplot}}, \code{\link{wtsplot}}
}

