% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{wilks.test}
\alias{wilks.test}
\title{Estimator test based on Wilks' theorem}
\usage{
wilks.test(x, estimator, side = "two")
}
\arguments{
\item{x}{a numeric vector or data frame.}

\item{estimator}{a numeric vector with estimated lambda and phi.}

\item{side}{a character string which selects the direction of wilks' theorem test
("two", "less" or "greater").}
}
\value{
\code{wilks.test} returns a list with these components:
\item{side}{a character string of one of "two", "less" or "greater".}
\item{stat}{a numeric value the statistics from Wilks' theorem.}
\item{pvalue}{a numeric value the p-value of the statistics.}
}
\description{
This is a test based on Wilks' theorem,
to determine which parameter space the estimated parameter is included in.
}
\details{
By Wilks' theorem, we can test the k-dimensional parameter with chi-square distribution.
The Wilks' theorem test can be performed by assuming the parameter space of null hypothesis
and setting the part not included in it as the parameter space of the alternative hypothesis.
}
\examples{
data <- fail_fiber
mme <- MME_WL(data)
wilks.test(data, mme, side="two")
wilks.test(data, mme, side="less")
wilks.test(data, mme, side="greater")

}
