% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{plot.WL}
\alias{plot.WL}
\title{Some plots for \code{WL}}
\usage{
\method{plot}{WL}(
  x,
  which = c(1, 2, 3, 4),
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  ...
)
}
\arguments{
\item{x}{an object of class "WL" made by the function \code{WL}.}

\item{which}{if a subset of the plots is required, specify a subset of 1:4; see 'Details' for a
description of the plots.}

\item{ask}{logical; if TRUE, the user is asked before each plot.}

\item{...}{other parameters to be passed through to plotting functions.}
}
\description{
\code{plot} method for a class "WL".
}
\details{
The first plot (\code{which=1}) is histogram of input values and pdf from estimated lambda and phi.
This is a good plot to judge how well the estimated values match the actual data.
\cr
\cr
The second plot (\code{which=2}) is the boxplot of the input data. It shows the simple information about median and outlier
points. Additionally, you can easily see which the "Outlier Points" are with box on the right side.\cr
\cr
The third plot (\code{which=3}) is Q-Q plot. This provides the same information as the normal Q-Q plot.\cr
\cr
The last plot (\code{which=4}) is contour plot of lambda and phi. You can observe the location of estimator, and also
compare estimator to Cox&Snell bias corrected MLE and MLEc.\cr
\cr
Plots are basically displayed one by one in the order mentioned above,
and it is also possible to view only one plot or four at a time.
How to do this is shown in the example below.
}
\examples{
example <- lifetime_alum
result <- WL(example)

plot(result)
plot(result, which=1)
plot(result, which=3)
par(mfrow = c(2, 2)) ; plot(result)
par(mfrow = c(1, 1))

}
\seealso{
See also \code{\link{WL}} and \code{\link{plot}}.
}
