% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atrous_vt.R
\name{at.wd}
\alias{at.wd}
\title{a trous (AT) based additive decompostion using Daubechies family wavelet}
\usage{
at.wd(x, wf, J, boundary = "periodic")
}
\arguments{
\item{x}{The input time series.}

\item{wf}{Name of the wavelet filter to use in the decomposition.}

\item{J}{Specifies the depth of the decomposition. This must be a number less than or equal to log(length(x),2).}

\item{boundary}{Character string specifying the boundary condition. If boundary=="periodic" the default, then the vector you decompose is assumed to be periodic on its defined interval, if boundary=="reflection", the vector beyond its boundaries is assumed to be a symmetric reflection of itself.}
}
\value{
A matrix of decomposed sub-time series.
}
\description{
a trous (AT) based additive decompostion using Daubechies family wavelet
}
\examples{
data(obs.mon)

n <- nrow(obs.mon)
v <- 1
J <- floor(log(n / (2 * v - 1)) / log(2)) # (Kaiser, 1994)

names <- colnames(obs.mon)
at.atm <- vector("list", ncol(obs.mon))
for (i in seq_len(ncol(obs.mon))) {
  tmp <- as.numeric(scale(obs.mon[, i], scale = FALSE))
  at.atm <- do.call(cbind, at.wd(tmp, wf = "haar", J = J, boundary = "periodic"))

  plot.ts(cbind(obs.mon[1:n, i], at.atm[1:n, 1:9]), main = names[i])
  print(sum(abs(scale(obs.mon[1:n, i], scale = FALSE) - rowSums(at.atm[1:n, ]))))
}
}
\references{
Nason, G. P. (1996). Wavelet shrinkage using cross-validation. Journal of the Royal Statistical Society: Series B (Methodological), 58(2), 463-479.
}
