% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{svdLSplus}
\alias{svdLSplus}
\title{Internal function: Uses SVD components to compute final estimate via
Sherman-Morrison-Woodbury formula.}
\usage{
svdLSplus(U, V, singularVals, y, ell, geB)
}
\arguments{
\item{U}{Left singular vectors of \eqn{\bar{Z}} or \eqn{\bar{Z}_{1}}
from \code{\link[base]{svd}}.}

\item{V}{Right singular vectors of \eqn{\bar{Z}} or \eqn{\bar{Z}_{1}}
from \code{\link[base]{svd}}.}

\item{singularVals}{Singular values of \eqn{\bar{Z}} or \eqn{\bar{Z}_{1}}
from \code{\link[base]{svd}}.}

\item{y}{"Pseudo"-response, see details.}

\item{ell}{Vector \eqn{\bar{\ell}} from section
"Simplification for computing \eqn{\tilde{\gamma}_{u}}"
\insertCite{huynhwals;textual}{WALS}}

\item{geB}{Scalar \eqn{\bar{g} \bar{\epsilon} / (1 + B)}. See section
"Simplification for computing \eqn{\tilde{\gamma}_{u}}"
\insertCite{huynhwals;textual}{WALS} for definition of
\eqn{\bar{g}}, \eqn{\bar{\epsilon}} and \eqn{B}.}
}
\description{
Solves the equation system in walsNB via Sherman-Morrison-Woodbury formula
for the unrestricted estimator \eqn{\hat{\gamma}_{u}}.
}
\details{
The function can be reused for the computation of the fully restricted
estimator \eqn{\tilde{\gamma}_{1r}} and the model averaged estimator
\eqn{\hat{\gamma}_{1}}.

For \eqn{\tilde{\gamma}_{1r}} and \eqn{\hat{\gamma}_{1}} use
\code{U}, \code{V} and \code{singularVals} from SVD of \eqn{\bar{Z}_{1}}.

For \eqn{\hat{\gamma}_{u}} and \eqn{\tilde{\gamma}_{1r}} use same
pseudo-response \eqn{\bar{y_{0}} - \bar{t} \bar{\epsilon} \bar{\Psi}^{-1/2} \bar{q}}
in argument \code{y}.

For \eqn{\hat{\gamma}_{1}} use pseudo-response
\eqn{\bar{y_{0}} - \bar{t} \bar{\epsilon} \bar{\Psi}^{-1/2} \bar{q} -
(\bar{Z}_{2} + \bar{g} \bar{\epsilon} \bar{\Psi}^{-1/2} \bar{q} \bar{q}^{\top}
Z_{2}) \hat{\gamma}_{2}}.

See section "Note on function svdLSplus from WALS"
in \insertCite{huynhwals;textual}{WALS}.
}
\references{
\insertAllCited{}
}
