% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/familyPrior.R, R/wals.R
\name{familyPrior}
\alias{familyPrior}
\alias{weibull}
\alias{subbotin}
\alias{laplace}
\alias{familyPrior_laplace}
\alias{print.familyPrior}
\alias{familyPrior.wals}
\title{Family Objects for Prior Distributions in WALS}
\usage{
familyPrior(object, ...)

weibull(q = 0.887630085544086, b = log(2))

subbotin(q = 0.799512530172489, b = 0.937673273794677)

laplace(b = log(2))

\method{print}{familyPrior}(x, digits = max(3, getOption("digits") - 3), ...)

\method{familyPrior}{wals}(object, ...)
}
\arguments{
\item{object, x}{Object of of class \code{"familyPrior"} or \code{"\link[WALS]{wals}"}.
The function \code{familyPrior()} accesses the \code{"familyPrior"} objects
that are stored in objects of class \code{"\link[WALS]{wals}"}.}

\item{...}{Further arguments passed to methods.}

\item{q}{\eqn{q} in \insertCite{magnus2016wals;textual}{WALS}.
Parameter of reflected generalized gamma distribution. See below for details.}

\item{b}{\eqn{c} in \insertCite{magnus2016wals;textual}{WALS}.
Parameter of reflected generalized gamma distribution. See below for details.}

\item{digits}{The number of significant digits to display.}
}
\value{
An object of class \code{"familyPrior"} to be used in
\code{\link[WALS]{wals}}, \code{\link[WALS]{walsGLM}} and \code{\link[WALS]{walsNB}}.
This is a list with the elements
\item{q}{Parameter \eqn{q}.}
\item{alpha}{Parameter \eqn{\alpha} (of the reflected generalized gamma
distribution).}
\item{b}{Parameter \eqn{c}.}
\item{delta}{Parameter \eqn{\delta = (1 - \alpha)/q}.}
\item{printPars}{vector. Contains the parameters that are shown in printing
functions, e.g. \code{print.familyPrior()}.}
\item{prior}{String with the name of the prior distribution.}

\code{laplace()} returns an object of the specialized class
\code{"familyPrior_laplace"} that inherits from \code{"familyPrior"}.
This allows separate processing of the Laplace prior in the estimation
functions as closed-form formulas exists for its posterior mean and variance.
The list elements are the same as for objects of class \code{"familyPrior"}.
}
\description{
\code{"familyPrior"} objects provide a convenient way to specify the prior
distribution used for the Bayesian posterior mean estimation of the WALS
estimators in \code{\link[WALS]{wals}}, \code{\link[WALS]{walsGLM}} and
\code{\link[WALS]{walsNB}}
}
\details{
\code{familyPrior()} is a generic function that extracts the family used in
\code{"\link[WALS]{wals}"} objects.

The density function of the reflected generalized gamma distribution is
\deqn{\pi(x) = \frac{q c^{(1 - \alpha)/q}}{2 \Gamma((1 - \alpha)/q)}
               |x|^{-\alpha} \exp(-c |x|^{q}).}

The double (reflected) Weibull, Subbotin and Laplace distributions are all
special cases of the reflected generalized gamma distribution. The Laplace
distribution is also a special case of the double Weibull and of the Subbotin
distribution.

The double (reflected) Weibull density sets \eqn{q = 1 - \alpha}, the Subbotin
density sets \eqn{\alpha = 0} and the Laplace density sets \eqn{\alpha = 0}
and \eqn{q = 1}.

The default values for the parameters \code{q} and \code{b} are minimax regret
solutions for the corresponding priors. The double (reflected) Weibull and
Subbotin prior are both neutral and robust. In contrast, the Laplace prior
is only neutral but not robust. See section 9 "Enter Bayes: Neutrality and
Robustness" of \insertCite{magnus2016wals;textual}{WALS} for details and
Table 1 for the optimal parameter values.
}
\examples{
## Use in wals():
fit <- wals(gdpgrowth ~ lgdp60 + equipinv + school60 + life60 + popgrowth |
            law + tropics + avelf + confucian, data = GrowthMPP,
            prior = weibull(q = 0.8, b = log(1.8)))
summary(fit)

}
\references{
\insertAllCited{}
}
\seealso{
\link{wals}, \link{walsGLM}, \link{walsNB}, \link{computePosterior}, \link{ddweibull},
\link{dsubbotin}, \link{dlaplace}.
}
