% Generated by roxygen2 (4.0.2): do not edit by hand
\name{scattmatrixMiss}
\alias{scattmatrixMiss}
\title{Scatterplot matrix with information about missing/imputed values}
\usage{
scattmatrixMiss(x, delimiter = NULL, highlight = NULL,
  selection = c("any", "all"), plotvars = NULL, col = c("skyblue", "red",
  "orange"), alpha = NULL, pch = c(1, 3), lty = par("lty"),
  diagonal = c("density", "none"), interactive = TRUE, ...)
}
\arguments{
\item{x}{a matrix or \code{data.frame}.}

\item{delimiter}{a character-vector to distinguish between variables and
imputation-indices for imputed variables (therefore, \code{x} needs to have
\code{\link{colnames}}). If given, it is used to determine the corresponding
imputation-index for any imputed variable (a logical-vector indicating which
values of the variable have been imputed). If such imputation-indices are
found, they are used for highlighting and the colors are adjusted according
to the given colors for imputed variables (see \code{col}).}

\item{highlight}{a vector giving the variables to be used for highlighting.
If \code{NULL} (the default), all variables are used for highlighting.}

\item{selection}{the selection method for highlighting missing/imputed
values in multiple highlight variables.  Possible values are \code{"any"}
(highlighting of missing/imputed values in \emph{any} of the highlight
variables) and \code{"all"} (highlighting of missing/imputed values in
\emph{all} of the highlight variables).}

\item{plotvars}{a vector giving the variables to be plotted.  If \code{NULL}
(the default), all variables are plotted.}

\item{col}{a vector of length three giving the colors to be used in the
plot.  The second/third color will be used for highlighting missing/imputed
values.}

\item{alpha}{a numeric value between 0 and 1 giving the level of
transparency of the colors, or \code{NULL}.  This can be used to prevent
overplotting.}

\item{pch}{a vector of length two giving the plot characters.  The second
plot character will be used for the highlighted observations.}

\item{lty}{a vector of length two giving the line types for the density
plots in the diagonal panels (if \code{diagonal="density"}).  The second
line type is used for the highlighted observations.  If a single value is
supplied, it is used for both non-highlighted and highlighted observations.}

\item{diagonal}{a character string specifying the plot to be drawn in the
diagonal panels.  Possible values are \code{"density"} (density plots for
non-highlighted and highlighted observations) and \code{"none"}.}

\item{interactive}{a logical indicating whether the variables to be used for
highlighting can be selected interactively (see \sQuote{Details}).}

\item{\dots}{for \code{scattmatrixMiss}, further arguments and graphical
parameters to be passed to \code{\link{pairsVIM}}.  \code{par("oma")} will
be set appropriately unless supplied (see \code{\link[graphics]{par}}).  For
\code{TKRscattmatrixMiss}, further arguments to be passed to
\code{scattmatrixMiss}.}
}
\description{
Scatterplot matrix in which observations with missing/imputed values in
certain variables are highlighted.
}
\details{
\code{scattmatrixMiss} uses \code{\link{pairsVIM}} with a panel function
that allows highlighting of missing/imputed values.

If \code{interactive=TRUE}, the variables to be used for highlighting can be
selected interactively.  Observations with missing/imputed values in any or
in all of the selected variables are highlighted (as determined by
\code{selection}).  A variable can be added to the selection by clicking in
a diagonal panel.  If a variable is already selected, clicking on the
corresponding diagonal panel removes it from the selection.  Clicking
anywhere else quits the interactive session.

The graphical parameter \code{oma} will be set unless supplied as an
argument.

\code{TKRscattmatrixMiss} behaves like \code{scattmatrixMiss}, but uses
\code{\link[tkrplot]{tkrplot}} to embed the plot in a \emph{Tcl/Tk} window.
This is useful if the number of variables is large, because scrollbars allow
to move from one part of the plot to another.
}
\note{
Some of the argument names and positions have changed with version 1.3
due to a re-implementation and for more consistency with other plot
functions in \code{VIM}.  For back compatibility, the argument
\code{colcomb} can still be supplied to \code{\dots{}} and is handled
correctly.  Nevertheless, it is deprecated and no longer documented.  Use
\code{highlight} instead.  The arguments \code{smooth}, \code{reg.line} and
\code{legend.plot} are no longer used and ignored if supplied.
}
\examples{
data(sleep, package = "VIM")
## for missing values
x <- sleep[, 1:5]
x[,c(1,2,4)] <- log10(x[,c(1,2,4)])
scattmatrixMiss(x, highlight = "Dream")

## for imputed values
x_imp <- kNN(sleep[, 1:5])
x_imp[,c(1,2,4)] <- log10(x_imp[,c(1,2,4)])
scattmatrixMiss(x_imp, delimiter = "_imp", highlight = "Dream")
}
\author{
Andreas Alfons, Matthias Templ, modifications by Bernd Prantner
}
\references{
M. Templ, A. Alfons, P. Filzmoser (2012) Exploring incomplete
data using visualization tools.  \emph{Journal of Advances in Data Analysis
and Classification}, Online first. DOI: 10.1007/s11634-011-0102-y.
}
\seealso{
\code{\link{pairsVIM}}, \code{\link{marginmatrix}}
}
\keyword{hplot}

