% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_mat}
\alias{get_mat}
\alias{getMat.VCA}
\title{Transform list of VCA-object into VFP-matrix required for fitting.}
\usage{
get_mat(obj, vc = 1)
}
\arguments{
\item{obj}{(list) of VCA-objects}

\item{vc}{(integer, character) either an integer specifying a variance component
or the name of a variance component; can also be a vector of integers
specifying a continuous sequence of variance components always including
'error' (repeatability)}
}
\description{
Transform list of VCA-object into VFP-matrix required for fitting.
}
\examples{
\donttest{
library(VCA)
data(VCAdata1)
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
get_mat(lst)  # automatically selects 'total'
# pooled version of intermediate precision (error+run+day)
get_mat(lst, 4:6)
# only repeatability ('error')
get_mat(lst, "error")
# use remlVCA instead
lst2 <- remlVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
get_mat(lst2)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
