% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_check.R
\name{checkData}
\alias{checkData}
\title{Check Random Model for Given Dataset.}
\usage{
checkData(form, Data)
}
\arguments{
\item{form}{(formula) describing the model to be analyzed}

\item{Data}{(data.frame) with all variables used in 'form'}
}
\value{
(list) of length equal to the number of terms in 'form' 
			each element being a list of messages with identified, 
			potential problems.
}
\description{
This function is intended to check a variance component analysis
either before or after performing it. This is particularily important
for less experienced users who my not exactly know where error messages 
come from. External software using functions \code{\link{anovaVCA}}
or \code{\link{remlVCA}} also via function \code{\link{fitVCA}} may
also benefit from more user-friendly error messages.
}
\examples{
\dontrun{
data(dataEP05A2_1)
dat0 <- dataEP05A2_1[1:16,]
# everything should be ok
checkData(y~day/run, dat0)
# data identical response for all obs 
dat1 <- dat0
dat1$y <- dat1[1,"y"]
remlVCA(y~day/run, dat1)
checkData(y~day/run, dat1)
# now factor-levels have identical values
dat2 <- dat0
dat2$y <- dat2$y[rep(seq(1,7,2), rep(2,4))] 
checkData(y~day/run, dat2)
remlVCA(y~day/run, dat2, quiet=TRUE)
# indistinguishable terms are also problematic
dat3 <- data.frame(	y=rnorm(8,10),
						day=paste("day",rep(c(1,2),c(4,4))), 
						run=rep(c(2,1), c(4,4)))
checkData(y~day/run, dat3)
anovaVCA(y~day/run, dat3)
# no replicates, thus, no error variability
dat4 <- dat0[seq(1,15,2),]
dat4$day <- factor(dat4$day)
dat4$run <- factor(dat4$run)
checkData(y~day/run, dat4)
remlVCA(y~day/run, dat4)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
