% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{predict.VCA}
\alias{predict.VCA}
\title{Predictions from a Model Fitted by \code{fitLMM}}
\usage{
\method{predict}{VCA}(object, newdata = NULL, re = NULL,
  allow.new.levels = FALSE, ...)
}
\arguments{
\item{object}{(VCA) object fitted via function \code{\link{fitLMM}}}

\item{newdata}{(data.frame) with all variables required for the specified prediction,
i.e. the default settings require all variables of the original model, 
in case of \code{re=NA}, only variables corresponding to fixed effects are
required.}

\item{re}{(character) if NULL (default) all random effects will be included, 
to restrict predictions to the fixed effects use \code{re=NA}, for
a subset of random effects included in predictions use any valid
random effects specification, i.e. \code{object$random}}

\item{allow.new.levels}{(logical) if new levels (no part of the original fitted model) in newdata
are allowed. If FALSE (default), such new values in newdata will trigger
an error; if TRUE, then the prediction will use the unconditional (population-level)
values for data with previously unobserved levels (or NAs).}

\item{...}{additional arguments passdo or from other methods}
}
\value{
(numeric) vector of prediction results
}
\description{
Model returns fitted values in case \code{newdata} is NULL or evaluates
the fitted model employing user-specified data \code{newdata}. The default is that
fitted values incorporate fixed effects and random effects, leaving out the (conditional)
residuals only. If the interest lies in constraining predictions to the fixed effects only
set \code{re=NA} or incorporate just part of the random variability specifying distinct random
effects (see \code{re}.
}
\examples{
\dontrun{
# fit LMM with fixed lot and device effects and test for lot-differences
data(VCAdata1)
datS5 <- subset(VCAdata1, sample==5)
fitS5 <- fitLMM(y~(lot+device)/(day)/(run), datS5, "anova")
fitS5

# fitted values including fixed and random effects
pred0 <- predict(fitS5)
pred0
# sanity check:
all(round(pred0 + resid(fitS5) - datS5$y, 12) == 0)
# restrict to fixed effects
predict(fitS5, re=NA)
# restrict to fixed effects and dayly random effects
# see required names
fitS5$random
predict(fitS5, re="lot:device:day")

# check against original 'lmer'-predictions
# use version from VCA-package (ordinary data.frame)
data(Orthodont, package="VCA")
Ortho <- Orthodont
Ortho$age2 <- Ortho$age-11
# use exactly the same data, same ordering
Ortho <- orderData(Ortho, distance ~ Sex * age2 + (Subject) * age2)
fit.fitLMM <- fitLMM(distance ~ Sex * age2 + (Subject) * age2, Ortho, "reml")
library(lme4)
fit.lmer <- lmer(distance ~ Sex + age2 + Sex:age2 + (age2 | Subject), Ortho)
# check fitted value first (fixed + random effects)
predict(fit.lmer)
predict(fit.fitLMM)
# restrict to fixed part only
predict(fit.lmer, re.form=NA)  
predict(fit.fitLMM, re=NA)
# user-specified 'newdata'
newdata <- Ortho[45:54,]
newdata$age2 <- newdata$age2 + 5
# include fixed and random effects
predict(fit.lmer, newdata)
predict(fit.fitLMM, newdata)
# generate new data
newdata <- Ortho[45:54,]          
newdata$age2 <- newdata$age2 + 5
# predict on newdata using fixed and random effects
predict(fit.lmer, newdata) 
predict(fit.fitLMM, newdata)       
# restrict prediction to random Subject effects
predict(fit.lmer, newdata, re.form=~(1|Subject))        
predict(fit.fitLMM, newdata, re="Subject")
# restrict prediction to random per-Subject slope
predict(fit.lmer, newdata, re.form=~(age2-1|Subject)) 
predict(fit.fitLMM, newdata, re="age2:Subject")
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzeneister@roche.com}
}
