% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{US_elec}
\alias{US_elec}
\title{The US Hourly Demand and Supply for Electricity}
\format{A tsibble object with hourly intervals}
\source{
US Energy Information Administration (Dec 2019) \href{https://www.eia.gov/}{website}
}
\usage{
US_elec
}
\description{
The total hourly demand and supply (generation) for electricity in the US since July 2015

Units: megawatthours

Time zone: UTC
}
\details{
The dataset contains the hourly demand and supply (generation) for electricity in the US (megawatthours).
The `type` column describes the type of the series (demand or generation)
}
\examples{

data(US_elec)

library(plotly)

plot_ly(data = US_elec,
        x = ~ date_time,
        y = ~ series,
        color = ~ type,
        type = "scatter",
        mode = "lines")

}
\keyword{datasets}
\keyword{time-series}
