% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaPrepare.R
\name{XenaPrepare}
\alias{XenaPrepare}
\title{Prepare (Load) Downloaded Datasets to R}
\usage{
XenaPrepare(
  objects,
  objectsName = NULL,
  use_chunk = FALSE,
  chunk_size = 100,
  subset_rows = TRUE,
  select_cols = TRUE,
  callback = NULL,
  comment = "#",
  na = c("", "NA", "[Discrepancy]"),
  ...
)
}
\arguments{
\item{objects}{a object of character vector or data.frame. If \code{objects} is data.frame,
it should be returned object of \link{XenaDownload} function. More easier way is
that objects can be character vector specify local files/directory and download urls.}

\item{objectsName}{specify names for elements of return object, i.e. names of list}

\item{use_chunk}{default is \code{FALSE}. If you want to select subset of original data, please set it to
\code{TRUE} and specify corresponding arguments: \code{chunk_size}, \code{select_direction}, \code{select_names},
\code{callback}.}

\item{chunk_size}{the number of rows to include in each chunk}

\item{subset_rows}{logical expression indicating elements or rows to keep:
missing values are taken as false. \code{x} can be a representation of data frame
you wanna do subset operation. Of note, the first colname of most of datasets
in Xena will be set to "sample", you can use it to select rows.}

\item{select_cols}{expression, indicating columns to select from a data frame.
'x' can be a representation of data frame you wanna do subset operation,
e.g. \code{select_cols = colnames(x)[1:3]} will keep only first to third column.}

\item{callback}{a function to call on each chunk, default is \code{NULL},
this option will overvide operations of subset_rows and select_cols.}

\item{comment}{a character specify comment rows in files}

\item{na}{a character vectory specify \code{NA} values in files}

\item{...}{other arguments transfer to \code{read_tsv} function or
\code{read_tsv_chunked} function (when \code{use_chunk} is \code{TRUE}) of \code{readr} package.}
}
\value{
a list contains file data, which in way of tibbles
}
\description{
Prepare (Load) Downloaded Datasets to R
}
\examples{
\donttest{
xe = XenaGenerate(subset = XenaHostNames == "tcgaHub")
hosts(xe)
xe_query = XenaQuery(xe)

xe_download = XenaDownload(xe_query)
dat = XenaPrepare(xe_download)
}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
