% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/File_Reading_Functions.R
\name{read_IMU}
\alias{read_IMU}
\title{File reading function for IMU files}
\usage{
read_IMU(file, output_window_secs = 1, verbose = FALSE)
}
\arguments{
\item{file}{character scalar giving the path to the IMU file}

\item{output_window_secs}{the desired epoch length; defaults to one second}

\item{verbose}{A logical scalar: print progress updates?}
}
\value{
A dataframe giving processed IMU data in the specified epoch length
}
\description{
File reading function for IMU files
}
\examples{
\dontrun{
imu_file <-
    system.file("extdata",
        "TestID_LeftWrist_IMU.csv",
        package = "TwoRegression")

read_IMU(imu_file)
}

}
