% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TukeyGH.R
\name{TukeyGH}
\alias{TukeyGH}
\alias{dGH}
\alias{rGH}
\alias{qGH}
\alias{pGH}
\title{Tukey \eqn{g}-&-\eqn{h} Distribution}
\usage{
dGH(x, A = 0, B = 1, g = 0, h = 0, log = FALSE, ...)

rGH(n, A = 0, B = 1, g = 0, h = 0)

qGH(p, A = 0, B = 1, g = 0, h = 0, lower.tail = TRUE, log.p = FALSE)

pGH(q, A = 0, B = 1, g = 0, h = 0, lower.tail = TRUE, log.p = FALSE, ...)
}
\arguments{
\item{x, q}{\link[base]{double} \link[base]{vector}, quantiles}

\item{A}{\link[base]{double} scalar, location parameter \eqn{A=0} by default}

\item{B}{\link[base]{double} scalar, scale parameter \eqn{B>0}. Default \eqn{B=1}}

\item{g}{\link[base]{double} scalar, skewness parameter \eqn{g=0} by default (i.e., no skewness)}

\item{h}{\link[base]{double} scalar, elongation parameter \eqn{h\geq 0}. Default \eqn{h=0} (i.e., no elongation)}

\item{log, log.p}{\link[base]{logical} scalar, if \code{TRUE}, probabilities \eqn{p} are given as \eqn{\log(p)}.}

\item{...}{other parameters of function \link{vuniroot2}}

\item{n}{\link[base]{integer} scalar, number of observations}

\item{p}{\link[base]{double} \link[base]{vector}, probabilities}

\item{lower.tail}{\link[base]{logical} scalar, if \code{TRUE} (default), probabilities are \eqn{Pr(X\le x)} otherwise, \eqn{Pr(X>x)}.}
}
\value{
Function \link{dGH} returns the density and accommodates \link[base]{vector} arguments \code{A}, \code{B}, \code{g} and \code{h}.
The quantiles \code{x} can be either \link[base]{vector} or \link[base]{matrix}.
This function takes about 1/5 time of \code{gk::dgh}.

Function \link{pGH} returns the distribution function, only taking scalar arguments and \link[base]{vector} quantiles \eqn{q}.
This function takes about 1/10 time of function \code{gk::pgh}.

Function \link{qGH} returns the quantile function, only taking scalar arguments and \link[base]{vector} probabilities \eqn{p}.

Function \link{rGH} generates random deviates, only taking scalar arguments.
}
\description{
Density, distribution function, quantile function and simulation
for Tukey \eqn{g}-&-\eqn{h} distribution with
location parameter \eqn{A},
scale parameter \eqn{B},
skewness \eqn{g} and
elongation \eqn{h}.
}
\examples{
(x = c(NA_real_, rGH(n = 5L, g = .3, h = .1)))
dGH(x, g = c(0,.1,.2), h = c(.1,.1,.1))

p0 = seq.int(0, 1, by = .2)
(q0 = qGH(p0, g = .2, h = .1))
range(pGH(q0, g = .2, h = .1) - p0)

q = (-2):3; q[2L] = NA_real_; q
(p1 = pGH(q, g = .3, h = .1))
range(qGH(p1, g = .3, h = .1) - q, na.rm = TRUE)
(p2 = pGH(q, g = .2, h = 0))
range(qGH(p2, g = .2, h = 0) - q, na.rm = TRUE)

curve(dGH(x, g = .3, h = .1), from = -2.5, to = 3.5)

}
