.help.ESS <-
function (topic, package = NULL, lib.loc = NULL, verbose = getOption("verbose"), 
    try.all.packages = getOption("help.try.all.packages"), help_type = getOption("help_type")) 
{
    if (!missing(package)) 
        if (is.name(y <- substitute(package))) 
            package <- as.character(y)
    if (missing(topic)) {
        if (!missing(package)) 
            return(library(help = package, lib.loc = lib.loc, 
                character.only = TRUE))
        if (!missing(lib.loc)) 
            return(library(lib.loc = lib.loc))
        topic <- "help"
        package <- "utils"
        lib.loc <- .Library
    }
    ischar <- tryCatch(is.character(topic) && length(topic) == 
        1L, error = identity)
    if (inherits(ischar, "error")) 
        ischar <- FALSE
    if (!ischar) {
        reserved <- c("TRUE", "FALSE", "NULL", "Inf", "NaN", 
            "NA", "NA_integer_", "NA_real_", "NA_complex_", "NA_character_")
        stopic <- deparse(substitute(topic))
        if (!is.name(substitute(topic)) && !stopic %in% reserved) 
            stop("'topic' should be a name, length-one character vector or reserved word")
        topic <- stopic
    }
    help_type <- if (!length(help_type)) 
        "text"
    else match.arg(tolower(help_type), c("text", "html", "postscript", 
        "ps", "pdf"))
    paths <- index.search(topic, find.package(package, lib.loc, 
        verbose = verbose))
    tried_all_packages <- FALSE
    if (!length(paths) && is.logical(try.all.packages) && !is.na(try.all.packages) && 
        try.all.packages && missing(package) && missing(lib.loc)) {
        for (lib in .libPaths()) {
            packages <- .packages(TRUE, lib)
            packages <- packages[is.na(match(packages, .packages()))]
            paths <- c(paths, index.search(topic, file.path(lib, 
                packages)))
        }
        paths <- paths[paths != ""]
        tried_all_packages <- TRUE
    }
    paths <- unique(paths)
    attributes(paths) <- list(call = match.call(), topic = topic, 
        tried_all_packages = tried_all_packages, type = help_type)
    class(paths) <- "help_files_with_topic"
    paths
}
.Random.seed <-
c(403L, 136L, 1980538363L, -125047968L, -820381145L, -1073960099L, 
-33499050L, 1164085917L, 1218464490L, -1045685882L, -1933699935L, 
795942478L, 495210185L, 1943097543L, -229514104L, -1232480817L, 
352489432L, 351006324L, -867325393L, -1442019852L, 629147155L, 
966152721L, 1616591578L, 200016369L, 1339052126L, -225299422L, 
-1512315715L, 103118938L, 1508496509L, 226325507L, 1531586180L, 
1851232347L, -180012444L, 1939719752L, 1161394291L, 1375986488L, 
-1867206193L, -269449371L, 1080036398L, 1121658053L, 1200423730L, 
-1114719938L, 1019413465L, 699098406L, -2049351935L, -216610673L, 
1752238736L, -1881625753L, 1183034576L, 289280140L, -1743926729L, 
-243822724L, -1713104501L, -866739415L, -2073616446L, -1798597783L, 
1624378294L, -511303094L, -484622395L, -1576496876L, 996804790L, 
-917710736L, 1806554914L, -22198181L, -722998599L, 410108957L, 
1149778011L, 1459463378L, -1618359224L, 845376994L, 637274396L, 
-1432005815L, 1437723723L, 1902160615L, 1262833869L, -1911506640L, 
-1518922062L, 1373330532L, 883641086L, 380847L, -1184588235L, 
-275900831L, -1432937449L, 586023422L, -849877260L, 463821014L, 
-270234328L, -2144570915L, -1207087337L, 1190567323L, 1689142169L, 
1175822956L, 1904310766L, -2004549720L, 438376634L, -1394835005L, 
-121754383L, 1087076069L, 584586339L, 107315546L, 110581328L, 
-774253782L, 322028116L, -1036237599L, 1593876099L, 1065739567L, 
1846277637L, 963650216L, -2078226102L, -498934596L, -626315018L, 
723134007L, 931715149L, 60391561L, 597152831L, 791758566L, -1727454852L, 
1129299070L, -826899616L, 1471815573L, 1323965647L, 385117571L, 
-1210125359L, 584755140L, -1507369530L, -1630192576L, -517807086L, 
-571062293L, 272680041L, 1894989389L, 1425886795L, -296480926L, 
702856184L, -1681846510L, -1472159124L, 273436889L, 1327605851L, 
1856875895L, -1096069219L, 924953536L, 1110396098L, -922946572L, 
570967086L, 343580095L, 612081381L, 2109955057L, 1830151207L, 
-1652127890L, 2077242340L, -1182212794L, 1554609304L, -178802003L, 
-1741074873L, 876484779L, -138661239L, -194324964L, -1302787650L, 
1604305720L, -845765270L, 761367059L, 286667873L, -2061365355L, 
-1822701485L, -443807062L, -1431880576L, -943009510L, 826639332L, 
193208881L, 1060164691L, -1018766401L, -2131691499L, 1422972600L, 
693581146L, 859577612L, 134206822L, -861972985L, 415151805L, 
-1569592615L, -1595615089L, -38970474L, -573925972L, -509242194L, 
1450628496L, 1297158309L, 1107000575L, 449088467L, 1181799169L, 
-1383618252L, 141546518L, 575856144L, -1510208958L, 791485563L, 
571913753L, -427005123L, 176980475L, -909485774L, 1663554728L, 
-1719394814L, -1913820036L, -642612695L, -1719239189L, -1926862073L, 
1015704877L, -1550711536L, 1897118226L, -1607617020L, 1275173406L, 
1012447567L, 103797525L, -1650061759L, 1790336887L, 325626846L, 
-1609980844L, -1443351626L, -1315423352L, -79557059L, -311237705L, 
1063514811L, 1174518585L, -1703642100L, 1304192654L, 1789749448L, 
2048347290L, -1932651421L, -2024483631L, 1563770629L, 73898051L, 
707232506L, 616261360L, 704593034L, -1416266956L, -345343423L, 
-1439682653L, -1889542257L, 1834668133L, 1053726728L, -827427286L, 
-2097712868L, 368026774L, 1417196055L, 1519961325L, -1825545879L, 
-16419745L, 1825800198L, 716299100L, -1807956770L, -1324393152L, 
1925488821L, 326096495L, 1697180579L, 517499505L, 1088607076L, 
-1897394138L, -1965803424L, 656225202L, 805488779L, 1644082121L, 
213671917L, 2072270699L, -1622521662L, 1939475672L, 1890787634L, 
707647436L, -1916513735L, -739951493L, 1005398807L, 1273857405L, 
516630432L, -1924956126L, 941044500L, 1814913486L, -1704451617L, 
-534041403L, 281412817L, -475276921L, 904658254L, 756476612L, 
-1950127194L, -370800520L, -1416311027L, -1555906073L, -1976536885L, 
-327526743L, 926657084L, -872015138L, -455521832L, -1105296132L, 
1314064768L, -1833163414L, 1525557867L, -2086205717L, -2106114529L, 
1750183917L, 1402811018L, 2121599494L, -1514668274L, 1789977404L, 
1804828197L, -82739535L, 1044404073L, 1824048843L, 172317904L, 
-418259704L, -1460278612L, 931696878L, 202599327L, 1450658015L, 
-214279669L, -1634230007L, -1916141370L, 1749006826L, -685331598L, 
919572488L, -338767L, -855323459L, -565531379L, 1798641407L, 
421964228L, 577509668L, 1113407128L, -1657021822L, 1575406067L, 
-1781653165L, -1834104809L, 127588245L, 1666082818L, 417635150L, 
1868688774L, -1161682316L, 426014637L, -1229536263L, 1481653585L, 
2026697715L, 713524648L, 739408608L, -2089412364L, -1006873546L, 
-892287913L, 1629967031L, 657944211L, 1428628513L, 763220142L, 
1141569474L, -586336902L, 1359023952L, -1821931639L, 619923605L, 
1249165925L, 1256352759L, -616761428L, 857839788L, -2005944240L, 
-1895061446L, -835570469L, -1564404389L, 1759702639L, 1436432445L, 
210900858L, -2023817930L, 1774770654L, -86437716L, -1399046411L, 
1418867169L, 1388343801L, 1742237851L, -818439648L, 1356679128L, 
1159213852L, -1996007714L, 2060155919L, 623546095L, 873516987L, 
1184786969L, 502484630L, -75589606L, 1458888066L, -1622834760L, 
1559476833L, -1644782355L, -1492794691L, 207161839L, -399818988L, 
-682203980L, -1250108536L, 247633394L, -1444908733L, 259589347L, 
1745526279L, -1239523131L, -507121518L, -1169282338L, -1011136010L, 
-93315196L, 1886091229L, 68903689L, 1881553217L, -60416093L, 
-1612118888L, 659924176L, 1690294724L, 1616569542L, 1432268455L, 
-50453529L, 559058339L, -1991628271L, -1820685154L, -779481838L, 
-749891094L, -128191712L, 2143460313L, 849139301L, 1709237493L, 
1251924039L, 1351389212L, -818950692L, 482002080L, 1944196042L, 
-1230654645L, 1639819147L, 1875917567L, -449099955L, 439110634L, 
-507730778L, 1953268142L, -1348028516L, -1238417531L, -1451510959L, 
-521402167L, -1296891861L, 1166177968L, -41050392L, 1017413452L, 
-1816812402L, 743156863L, 351108991L, 1850326443L, -1433845335L, 
2072566758L, 995646602L, -842355822L, -1826360856L, -801381871L, 
-667949795L, -1932314131L, 1456116895L, 1462468068L, -365338364L, 
1706811640L, 382005346L, 704987411L, -1384319309L, -1416245833L, 
1063344693L, 738233250L, 882766702L, 1034614909L, -189422190L, 
588242311L, -267551754L, -533240099L, 1991196518L, -1875437903L, 
1794952952L, -1561023755L, 1000699398L, -116544433L, 401214986L, 
917641425L, 1692588966L, 1076991977L, 428108540L, 1475461149L, 
1736064394L, 1940532591L, 334313254L, 1762388861L, -776938L, 
-616690543L, 2128094184L, -1581197251L, 198487006L, -521431313L, 
1986138074L, 1302007169L, -923129554L, -1966832191L, -74710484L, 
912392925L, -2790254L, -1296023881L, -1779108266L, -2007800003L, 
-988022042L, -1691069039L, 1425852776L, -540657931L, -1166237722L, 
-519239409L, -1368853878L, -1434350239L, -815532106L, 1402351913L, 
1508708028L, 1792947533L, 933964298L, 383417087L, -1587872650L, 
-2140432019L, 970437382L, 1106500577L, 1417452616L, -1209893827L, 
1932748606L, 1300635465L, 784433113L, -1772047062L, -614851456L, 
550550105L, -934610935L, 1825560048L, -468798686L, -1411812251L, 
-1411738103L, 1662300882L, -1561081636L, 1446953397L, 1216616393L, 
635548356L, -814439558L, 1590512353L, -1630559807L, 316142498L, 
-2063831616L, -217001639L, -1138305823L, -1161666696L, 167656098L, 
-194523307L, -582937775L, 2041999306L, 1076095220L, 1799241709L, 
-1443440591L, 182444372L, -998449174L, -1572227031L, 1226168249L, 
-859164006L, -1357239552L, 1370496361L, -757766903L, 572980640L, 
-2067465326L, -560435707L, 214208089L, -1113319134L, -2001200500L, 
892451461L, 1585436489L, 2082318676L, -220896310L, -996825263L, 
-1704356495L, -1711580894L, 1271979456L, -661656791L, 105809745L, 
1278023928L, -1579682830L, -214878795L, -1997389039L, 765062026L, 
1731574196L, -1240695091L, 1888972705L, 1967925924L, 520547930L, 
-647645783L, -1985880871L, -652827318L, 1272906656L, 514889017L, 
822618185L, 915869392L, -465682366L, 556848421L, 95648009L, -651513870L, 
863467964L, -375347371L, 1981426537L, 176783780L, 523648218L, 
-589977567L, 1914642721L, -1871760254L, -1586947104L, -346442695L, 
703798945L, 732710968L, -165412766L, 1888428821L, 1893337521L, 
-743130742L, -1050505356L, 471691885L, -1581648751L, 1125688788L, 
2098523018L, 358039561L, -1567651463L, 597627866L, 1346302752L, 
-160376471L, 1063411465L, -623243680L, 897524434L, 995310533L, 
-1124453319L, -1103252830L, -1708500724L, -983918331L, 324701481L, 
-1224973676L, -1261295304L, -2057610510L)
