% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{BalancedTree}
\alias{BalancedTree}
\title{Generate a Balanced Tree}
\usage{
BalancedTree(tips)
}
\arguments{
\item{tips}{An integer specifying the number of tips, or a character vector
naming the tips, or any other object from which tip labels can be extracted
with function \code{TipLabels}.}
}
\value{
A tree of class \code{phylo}.
}
\description{
Generates a balanced (symmetrical) binary tree with the specified tip labels.
}
\examples{
plot(BalancedTree(LETTERS[1:10]))
}
\seealso{
Other tree generation functions: 
\code{\link{NJTree}()},
\code{\link{PectinateTree}()},
\code{\link{RandomTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
