% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jackknife.R
\name{JackLabels}
\alias{JackLabels}
\title{Label nodes with jackknife support values}
\usage{
JackLabels(
  tree,
  jackTrees,
  add = FALSE,
  adj = 0,
  col = NULL,
  frame = "none",
  pos = 2L,
  ...
)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{jackTrees}{A list or \code{multiPhylo} object containing trees generated
by \code{\link[=Jackknife]{Jackknife()}}.}

\item{add}{Logical specifying whether to add the labels to an existing
plot.}

\item{adj, col, frame, pos, \dots}{Parameters to pass to \code{nodelabels}.}
}
\value{
A named vector specifying the proportion of jackknife trees
consistent with each node in \code{tree}, as plotted.
}
\description{
Label nodes with jackknife support values
}
\examples{
library('TreeTools') # for as.phylo

# jackTrees will usually be generated with Jackknife(), but for simplicity:
jackTrees <- as.phylo(1:100, 8)

JackLabels(as.phylo(0, 8), jackTrees)

}
\seealso{
\code{\link[=Jackknife]{Jackknife()}}: Generate trees by jackknife resampling
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
