% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\encoding{UTF-8}
\name{SplitEntropy}
\alias{SplitEntropy}
\title{Entropy of two splits}
\usage{
SplitEntropy(split1, split2 = split1)
}
\arguments{
\item{split1, split2}{Logical vectors listing leaves in a consistent order,
identifying each leaf as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the split in question.}
}
\value{
A numeric vector listing, in bits:
\itemize{
\item \code{H1} The entropy of split 1;
\item \code{H2} The entropy of split 2;
\item \code{H12} The joint entropy of both splits;
\item \code{I} The mutual information of the splits;
\item \code{Hd} The entropy distance (variation of information) of the splits.
}
}
\description{
Calculate the entropy, joint entropy, entropy distance and information
content of two splits, treating each split as a division of \emph{n} leaves into
two groups.
Further details are available in a
\href{https://ms609.github.io/TreeDist/articles/information.html}{vignette},
\insertCite{Mackay2003;textual}{TreeDist} and
\insertCite{Meila2007;textual}{TreeDist}.
}
\examples{
A <- TRUE
B <- FALSE
SplitEntropy(c(A, A, A, B, B, B), c(A, A, B, B, B, B))
}
\references{
\insertAllCited{}
}
\seealso{
Other information functions: 
\code{\link{SplitSharedInformation}()},
\code{\link{TreeInfo}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{information functions}
