% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSankeyDiagram.R
\name{createSankeyDiagram}
\alias{createSankeyDiagram}
\title{createSankeyDiagram}
\usage{
createSankeyDiagram(
  treatmentPathways,
  groupCombinations = FALSE,
  colors = NULL,
  ...
)
}
\arguments{
\item{treatmentPathways}{(\code{data.frame()})\cr
The contents of the treatmentPathways.csv-file as a data.frame().}

\item{groupCombinations}{(\code{logical(1)}: \code{FALSE})\cr
\describe{
\item{\code{TRUE}}{Group all combination treatments in category \code{"Combination"}.}
\item{\code{FALSE}}{Do not group combination treatments.}
}}

\item{colors}{(\code{character(n)}) Vector of hex color codes.}

\item{...}{Paramaters for \link[networkD3]{sankeyNetwork}.}
}
\value{
(\code{htmlwidget})
}
\description{
Create sankey diagram, will replace \code{createSankeyDiagram}.
}
\examples{
# Dummy data, typically read from treatmentPathways.csv
treatmentPathways <- data.frame(
  path = c("Acetaminophen", "Acetaminophen-Amoxicillin+Clavulanate",
           "Acetaminophen-Aspirin", "Amoxicillin+Clavulanate", "Aspirin"),
  freq = c(206, 6, 14, 48, 221),
  sex = rep("all", 5),
  age = rep("all", 5),
  index_year = rep("all", 5)
)

createSankeyDiagram(treatmentPathways)
}
