% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tce.R
\name{Total_Carbon_Emissions}
\alias{Total_Carbon_Emissions}
\title{Total Carbon Emissions}
\usage{
Total_Carbon_Emissions(portfolio_exposure, emissions_capitalization_data)
}
\arguments{
\item{portfolio_exposure}{The exposure per issuer in the portfolio}

\item{emissions_capitalization_data}{The capitalization and the Scope 1 & 2 GHG emissions per issuer}
}
\value{
The absolute greenhouse gas emissions associated with a portfolio, expressed in tons CO2e
}
\description{
Returns the absolute greenhouse gas emissions associated with a portfolio, expressed in tons CO2e.
Under this approach, if an investor owns 5 percent of a company's total market capitalization, then the investor 
owns 5 percent of the company as well as 5 percent of the company's GHG (or carbon) emissions.
}
\examples{
 portfolio_exposure     = data.table::data.table(Issuers = c('A','B','C'),
 exposures = c(100, 200, 50))
 emissions_capitalization_data = data.table::data.table(Issuers = c('A','B','C'),
  emissions = c(1000, 5000, 6000),
  Capitalization = c(20000, 10000, 30000))
 Total_Carbon_Emissions(portfolio_exposure, emissions_capitalization_data)
}
\references{
https://www.tcfdhub.org/Downloads/pdfs/E09%20-%20Carbon%20footprinting%20-%20metrics.pdf
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
