#' 
#' Creates an Equity object 
#' @title Equity Class
#' @param Notional The notional amount of the trade
#' @docType NULL
#' @param MTM      The mark-to-market valuation of the trade
#' @param Currency The currency set that the trade belongs to
#' @param Si The number of years that the trade will take to start (zero if already started)
#' @param BuySell Takes the values of either 'Buy' or 'Sell'
#' @param ISIN the ISIN of the Equity
#' @param traded_price the price that trade was done
#' @return An object of type EquityIndexFuture
#' @export
#' @author Tasos Grivas <tasos@@openriskcalculator.com>
#' @examples
#' 
#'
#' tr1 = Equity(Notional=10000,MtM=30,Currency="EUR",Si=0,BuySell='Buy',traded_price = 10,ISIN = "XS04340432")
# This is used to represent the Equity asset class
#' @include Trade.R
Equity = setRefClass("Equity",
                 contains="Trade",
                 methods = list(
                   initialize = function(...){
                     SubClass<<-' '
                     callSuper(...,TradeGroup='EQ', TradeType='Single')
                   }
                 ))
#' 
#' Creates an Equity Index Future object with the relevant info needed to calculate the Exposure-at-Default (EAD)
#' @title Equity Index Future Class
#' @param Notional The notional amount of the trade
#' @docType NULL
#' @param MTM      The mark-to-market valuation of the trade
#' @param Currency The currency set that the trade belongs to
#' @param Si The number of years that the trade will take to start (zero if already started)
#' @param Ei The number of years that the trade will expire
#' @param BuySell Takes the values of either 'Buy' or 'Sell'
#' @param traded_price the price that trade was done
#' @return An object of type EquityIndexFuture
#' @export
#' @author Tasos Grivas <tasos@@openriskcalculator.com>
#' @examples
#' 
#'
#' tr1 = EquityIndexFuture(Notional=10000,MtM=30,Currency="EUR",Si=0,Ei=10,BuySell='Buy',traded_price=10)

EquityIndexFuture = setRefClass("EquityIndexFuture",
                     
                     contains="Equity",
                     
                     methods = list(
                       initialize = function(...){
                         callSuper(...,TradeType='Index')
                       }
                       
                     ))