\name{NEWS}
\title{NEWS file for the TraMineRextras package}

\section{Changes in version 0.4.6 [2019-09-06]}{
  \subsection{Changes in existing functions}{
    \itemize{
      \item
      \code{seqedplot()}: argument \code{title} is deprecated, use \code{main} instead.
      \item
      \code{seqedplot()}: when \code{type = 'survival'}, now supports the \code{conf.int} argument of \code{plot.survfit} to control the display of confidence intervals.
    }
  }

  \subsection{Bug fixes}{
    \itemize{
      \item
      \code{seqedplot()}: An issue with the joint use of the \code{xmax} and \code{xlim} arguments when calling \code{plot.survfit} raised a warning since \code{Survival} v3.0.
    }
  }
}


\section{Changes in version 0.4.5 [2019-05-06]}{
  \subsection{Changes in existing functions}{
    \itemize{
      \item
      \code{seqprecarity()} and \code{seqprecstart()} gain an argument \code{with.missing}.
      \item
      \code{seqprecarity()}: there is now a print method for the generated \code{seqprec} object that prevents the printing of all its attributes.
      \item
      \code{seqprecorr()}: new \code{border.effect} argument. To avoid a border
        effect, when method is \code{'FREQ'}, \code{'TRATEDSS'}, or \code{'TRATE'}, the
        computed transition frequencies or probabilities \eqn{p} are adjusted
        as \eqn{p - p/}\code{border.effect} when any \eqn{p > 1 - .1/}\code{border.effect}.
      \item
      \code{seqtabstocc()} gains an argument \code{with.missing}.
    }
  }

  \subsection{Bug fixes}{
    \itemize{
      \item
      \code{seqprecorr()}: \code{method='TRATE'} now works as expected.

      \item
      \code{seqprecarity()}, \code{seqprecorr()}, and \code{seqprecstart()}: errors due to bad handling of missing states.
      \item
      \code{seqedplot()} called \code{plot.survfit} with a \code{firstx} argument
        that has been suppressed (non documented in survival news);
        now uses \code{xlim} instead.

    }
  }
}

\section{Changes in version 0.4.4 [2018-12-14]}{
  \subsection{Changes in existing functions}{
    \itemize{
      \item
      \code{plot.stslist.surv()}: new \code{xlab} argument.
      \item
      \code{seqprecarity()}, \code{seqprecorr()}, and \code{seqprecstart()}: Important
        code cleaning.
      \item
      \code{seqprecarity()}, \code{seqprecorr()}: New argument \code{method} that
        replaces \code{tr.type} to select the type of transition weights.
        Two additional methods have been implemented, namely \code{'RANK'}
        (for rank-based transition weights) and \code{'ONE'} for
        non-weighted transitions. Also new argument \code{stprec} to allow
        specifying rank values for \code{method='RANK'}.
    }
  }

  \subsection{Bug fixes}{
    \itemize{
      \item
      \code{seqsurv()}: levels of spell$states were not ordered conformably with the alphabet of the state sequence object, which caused \code{plot.ststlist.surv} to use wrong colors for the survival curves when \code{per.state=FALSE}.
      \item
      \code{seqsplot()}: color synchronization failed when one of the states selected was unobserved in one of the groups.
      \item
      \code{seqprecorr()}: identification of non-comparable states did not work as expected.
      \item
      \code{seqprecstart()}: did not work as expected when equiv class included incomparable states.

    }
  }

}


\section{Changes in version 0.4.3 [2018-08-22]}{
  \subsection{Changes in existing functions}{
    \itemize{
      \item
      \code{seqsplot()} now supports the \code{ncol} argument for controlling the number of columns in the color legend.
      \item
      \code{plot.stslist.surv()}, \code{seqplot.tentrop()}, , \code{seqplot.tentrop.m()}, \code{plot.seqimplic()}, \code{print.seqimplic()}: new argument \code{tick.last} that when set as \code{TRUE} allows to enforce a tick mark at the last position on the time x-axis. Has no effect when the last position is 1 + a multiple of \code{xtstep}. Default is to use the \code{tick.last} attribute of the state sequence object.
      \item
      \code{seqrep.grp()}: an error is raised when one of the groups has less than two cases.
    }
  }
  \subsection{Bug fixes}{
    \itemize{
      \item{Function \code{seqgen.missing()} the number of left and right
        elements to be turned into missings were inverted.}
    }
  }
  \subsection{Misc}{
    \itemize{
      \item{Function \code{seqeordplot()} suppressed. It is superseded by the
       function \code{seqpcplot()} of the TraMineR package.}
    }
  }
}

\section{Changes in version 0.4.2 [2018-02-01]}{
  \subsection{New functions}{
    \itemize{
      \item
      \code{seqprecarity()}: computes the sequence precarity index from
      a provided partial state order. The index is a
      corrected complexity index. See documentation page.
      \item
      \code{seqprecorr()}: determines the correction factor used by
        \code{seqprecarity()}.
      \item
      \code{seqprecstart()}: determines the starting precarity level
        of the sequence from the partial state order.
      \item
      \code{seqsurv()}: fits survival curves for states in state sequences.
        There is a plot method for objects returned by \code{seqsurv()}.
      \item
        \code{seqsplot()}: specific version of the TraMineR \code{seqplot()} function
        to plotting survival curves of states in sequences.
    }
  }

  \subsection{Changes in existing functions}{
    \itemize{
      \item
      \code{seqrep.grp())} renamed argument names for consistency with TraMineR.
      \item
      \code{seqrep.grp())}: when \code{diss=NULL}, the dissimilarity matrix is now
      computed by calling \code{seqdist} with the \code{method} and possibly related parameters specified among the \code{...} arguments. An error is raised when \code{diss=NULL} and no \code{method} is provided.
    }
  }

  \subsection{Bug fixes}{
    \itemize{
      \item
      \code{seqtabstocc())}: label synchronization issues.
    }
  }

  \subsection{Misc}{
    \itemize{
      \item
      Uses function \code{TraMineR.check.depr.args()} introduced in TraMineR v 2.0-8. So, depends now on version >= 2.0-8.
    }
  }


}

\section{Changes in version 0.4.1 [2017-08-16]}{
  \subsection{Changes in existing functions}{
    \itemize{
      \item
      \code{STS_to_SPELL()}: Deleted. Converting to the \code{"SPELL"} format is now a feature
      of \code{seqformat()} in TraMineR 2.0-6+.
      \item
      \code{seqrep.grp()}: Added argument \code{with.missing} to allow computing the default distances (when \code{diss = NULL}) for sequences with missing values.
    }
  }

  \subsection{Misc}{
    \itemize{
      \item
      Replaced deprecated argument names in example of \code{seqrep.grp()}.
      \item
      Now imports from RColorBrewer, survival and cluster instead of depending on those packages.
      \item
      Suppressed unused import from combinat.
      \item
      \code{init.c} file.
    }
  }

}

\section{Changes in version 0.4.0 [2017-05-13]}{

\subsection{Note}{
  \itemize{
    \item
    TraMineRextras has been adapted to and requires now TraMineR 2.0-5.
  }
}

\subsection{Bug Fixes}{
  \itemize{
    \item
    \code{TSE_to_STS()}: The two last sequences were not converted and unexpected outcome in case of a single sequence.
    }
}

\subsection{Changes in existing functions}{
  \itemize{
    \item
    \code{seqplot.rf()}, \code{seqplot.tentrop()}, \code{seqrep.grp()}, \code{dissvar.grp()}, \code{plot.seqimplic()}: adjusted argument names (main, with.legend, legend.pos, diss, ...) to conform to the TraMineR 2 naming convention.
    }
}
\subsection{Misc}{
  \itemize{
    \item
    \code{seqrep.grp()}: Removed \code{with.missing=TRUE} in a help example as \code{biofam.seq} doesn't contain missing values and to conform to TraMineR 2.0-5+.
    \item
    \code{seqeformat()}, \code{seqentrans()}, \code{seqerulesdisc()}: Renamed '\code{seqe}' as '\code{eseq}' in internal code to conform to TraMineR 2.0-5+.
    \item
    Adjusted examples in help files (\code{sortv}, \code{seqtabstocc}, \code{seqrep.grp}, \code{seqplot.tentrop}, \code{seqplot.fr}, \code{seqimplic}, \code{seqgranularity}, \code{seqgen.missing}, \code{seqedplot}, \code{seqentrans}) to conform to TraMineR 2.0-5+.
    }
}
}

\section{Changes in version 0.2.6 [2017-03-01]}{
\subsection{Misc}{
  \itemize{
    \item{Function \code{ctplot()} suppressed. It is superseded by the
       function \code{seqpcplot()} of the TraMineR package.}
    \item{C++ routines are now registered.}
}} }

\section{Changes in version 0.2.5 [2016-11-10]}{
\subsection{New functions}{
  \itemize{
    \item{\code{seqimplic()}: Identifies position wise typical states
    of groups of sequences when compared with all the others. There
    are also plot and print methods for the outcome of the function.}
}}
}

\section{Changes in version 0.2.4 [2015-07-23]}{
\subsection{New functions}{
  \itemize{
    \item{\code{seqplot.rf()}: Implements the Relative Frequency Sequence Plots
        introduced in Fasang and Liao (2014)}
}}
\subsection{Misc}{
  \itemize{
    \item{revised help page for \code{seqemlt()} (distance of Rousset et al. 2012).}
    \item{Added required basic packages to the import statements to
        comply with R v3.3 requirements.}
}}
}
\section{Changes in version 0.2.3 [2015-01-27]}{
\subsection{New functions}{
  \itemize{
    \item{\code{seqtabstocc()}: frequencies of state co-occurrence patterns}
}}
\subsection{Changes in existing functions}{
  \itemize{
    \item{\code{seqgranularity()}: new method \code{"mostfreq"}}
    \item{\code{seqedplot()}: replaced calls of TraMineR internal functions \code{seqeage}
        and \code{TraMineR.legend} with respectively
        \code{TraMineRInternalSeqeage} and \code{TraMineRInternalLegend}
        (should be transparent to the end user).}
}}}
\section{Changes in version 0.2.2 [2013-10-30]}{
\itemize{
    \item{Fixed issue with calling Rinternals from within extern "C" {}
        in seqstart.cpp (request of B. Ripley)}
}
}
\section{Changes in version 0.2.1 [2013-03-15]}{
\subsection{General}{
  \itemize{
    \item{NEWS is now in Rd format into inst/NEWS.Rd}
}}
\subsection{Bug Fixes}{
  \itemize{
    \item{
    \code{FCE_to_TSE()}: Events were not properly chronologically sorted.}
    \item{
    \code{TSE_to_STS()}: produced inconsistent results when events were not chronologically
    sorted by cases.}
}}}
\section{Changes in version 0.2 [2012-12-06]}{
\subsection{General}{
  \itemize{
    \item{
    First release on CRAN}
}}
\subsection{Changes in existing functions}{
  \itemize{
    \item{
    \code{seqplot.tentrop()} and \code{seqplot.tentrop.m()}: new argument \code{cex.legend}
        for controlling legend scaling factor.}
    \item{
    \code{seqentrans()}: new option \code{avg.occ}; when set as \code{TRUE} the table is
        completed with average number of occurrences of the subsequences
        in each sequence. The latter differs from the support for
        counting methods other than COBJ. Requires TraMineR 1.8-5 or higher.}
    \item{
    \code{dissvar.grp()} and \code{seqrep.grp()} now also accept distance objects as \code{mdis} argument.}
    \item{
    \code{group.p} has now a \code{weights} argument.}
}}
\subsection{Bug Fixes}{
  \itemize{
    \item{
    \code{seqedist()}: fixed a mix between norm and interval arguments.}
    \item{
    fixed build warning generated by calls of foreign functions.}
}}}
