% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rownames_to_symprobe.R
\name{rownames_to_symprobe}
\alias{rownames_to_symprobe}
\title{Rownames to symbol-probeID}
\usage{
rownames_to_symprobe(exprset, tt)
}
\arguments{
\item{exprset}{The output of \code{exprs(eset)}.}

\item{tt}{A topTable object.}
}
\value{
Character vector of the gene symbol with the probe ID.
}
\description{
This function takes an \code{exprs(eset)} matrix where the rownames are
probeset IDs and takes an annotated topTable output where you have an ID and
Symbol column and outputs a character vector with symbol_probeid for each
probeid in rownames(exprs(eset)). You can use this such that the output on a
heatmap contains the gene names concatenated to the probe ID in case you have
multiple symbols with the same probeID.
}
\examples{
\dontrun{
rownames_to_symprobe(esprs(eset), topTable(fit, number=nrow(fit)))
}
}
\author{
Stephen Turner
}
\keyword{NA}

