#' Number of seizures per patient.
#'
#' A (fictional) dataset containing the number of seizures per patient for different add-on treatments evaluating an anti-epileptic drug.
#'
#' @format A data frame with 18 rows and 3 variables:
#' \describe{
#'   \item{pla}{Placebo group}
#'   \item{ref}{Reference group}
#'   \item{exp}{Experimental treatment group}
#' }
"seizures"


#' Number of new and enlarging T2 lesions per patient.
#'
#' A (fictional) dataset containing the number of new and enlarging T2 lesions per patient for different treatments for multiple sclerosis.
#'
#' @format A data frame with 150 rows and 3 variables:
#' \describe{
#'   \item{pla}{Placebo group}
#'   \item{ref}{Reference group}
#'   \item{exp}{Experimental treatment group}
#' }
"T2lesions"


#' Total number of new galodinium-enhancing lesions.
#'
#' A (fictional) dataset containing the total number of new galodinium-enhancing lesions for different treatments for multiple sclerosis.
#'
#' @format A data frame with 50 rows and 3 variables:
#' \describe{
#'   \item{placebo}{Placebo group}
#'   \item{reference}{Reference group}
#'   \item{experimental}{Experimental treatment group}
#' }
"GElesions"




#' Remission in clinical trial in patients with depression.
#'
#' A dataset indicating whether a patient went into remission defined as a HAM-D total score of <= 7.
#'
#' @format A data frame with 88 rows and 3 variables:
#' \describe{
#'   \item{placebo}{Placebo group}
#'   \item{reference}{Reference group}
#'   \item{experimental}{Experimental treatment group}
#' }
"remission"
