% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taNegbin.test.R
\name{taNegbin.test}
\alias{taNegbin.test}
\title{Statistical test for three-armed clinical trials with negative binomial distributed endpoints.}
\usage{
taNegbin.test(xExp, xRef, xPla, Delta, method = c("RML", "ML",
  "SampleVariance"))
}
\arguments{
\item{xExp}{A (non-empty) numeric vector of data values coming from the experimental treatment group.}

\item{xRef}{A (non-empty) numeric vector of data values coming from the reference treatment group.}

\item{xPla}{A (non-empty) numeric vector of data values coming from the placebo group.}

\item{Delta}{A numeric value specifying the non-inferiority or superiority margin. Is between 0 and 1 in case of non-inferiority and larger than 1 in case of superiority.}

\item{method}{A character string determing how the variance for the Wald-type test statistic is estimated, must be \emph{RML}, \emph{ML}, or \emph{SampleVariance}.}
}
\value{
A list with class "htest" containing the following components:
\item{statistic}{The value of the Wald-type test statistic.}
\item{p.value}{The p-value for the Wald-type test.}
\item{method}{A character string indicating what type of Wald-type-test was performed.}
\item{estimate}{The estimated rates for each of the group as well as the maximum-likelihood estimator for the shape parameter.}
\item{sample.size}{The total number of data points used for the Wald-type test.}
}
\description{
Wald-type test for superiority/non-inferiority of the experimental treatment versus reference treatment with respect to placebo.
}
\details{
The hypothesis \eqn{(\lambda_P - \lambda_E)/(\lambda_P - \lambda_R) \le \Delta} is tested against the alternative \eqn{(\lambda_P - \lambda_E)/(\lambda_P - \lambda_R) > \Delta}.
\eqn{\lambda_E}, \eqn{\lambda_R}, \eqn{\lambda_P} are the rates of the experimental treatment (\code{rateExp}), the reference treatment (\code{rateRef}), and the placebo group (\code{ratePla}), respectively.
The margin \emph{Delta}, i.e. \eqn{\Delta} in the formulas above, is between 0 and 1 for testing non-inferiority and larger than 1 for testing superiority.
The parametrisation of the underlying negative binomial distributions is chosen such that
a negative binomial distribution of rate \eqn{\lambda} and shape parameter \eqn{\phi} has variance \eqn{\lambda(1+\phi \lambda)}.
The shape parameter \eqn{\phi} is assumed to be the same among the groups.
}
\examples{
# This function is outdated. Please use \\code{\\link{test_RET}}.
}
\references{
Muetze T et al. 2015. \emph{Statistical inference for three-arm trials with negative binomially distributed endpoints.} (Submitted.)
}
\seealso{
\code{\link{power.taNegbin.test}}
}
\keyword{NegativeBinomial}
\keyword{test}

