Usimulate <- function(theta.pop, WfdList) {
#  USIMULATE generates an Ntheta.pop by N matrix of random score index
#  values for N test questions and Ntheta.pop values of theta.pop
#  located at the score index values in SCRFINE.
#  The probabilities for each question are generated by interpolation
#  over the score values in SCRFINE of the probabilities in the MI
#  columns of matrix Pmati.

#  Last modified on 3 October 2021 by Jim Ramsay

  nfine   <- 101
  n       <- length(WfdList)
  indfine <- seq(0,100,len=101)
  ntheta.pop <- length(theta.pop)
  WList1 <- WfdList[[1]]
  Pmat1  <- WList1$Pmatfine
  scrmin <-   0
  scrmax <- 100
  if (any(theta.pop < scrmin) || any(theta.pop > scrmax)) {
    stop("Values in theta.pop out of score index range.")
  }
  Umat <- matrix(0,ntheta.pop,n)
  for (i in 1:n) {
    WListi <- WfdList[[i]]
    Mi     <- WListi$M
    Pmati  <- WListi$Pmatfine
    for (j in 1:ntheta.pop) {
      prob = matrix(0,1,Mi)
      for (m in 1:Mi) {
        prob[m]  <- pracma::interp1(indfine, Pmati[,m], theta.pop[j])
      }
      prob  <- prob/apply(prob, 1, sum)
      if (any(prob < 0) || any(prob > 1)) {
        print(c(j,i,prob))
        stop("prob < 0 || prob > 1")
      }
      uval <- matrix(rmultinom(1,1,prob),1,Mi)
      if (!is.numeric(uval)) { 
        print(uval)
        print(prob)
        print(sum(prob)-1)
        stop("bad value for prob")
      }
      m  <- (1:Mi)[uval==1]
      if (m < 1 || m > Mi) {
        print(c(j,i,m))
        stop("m < 1 || m > Mi")
      }
      Umat[j,i] <- m
    }
  }
  
  return(Umat) 
  
}