% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmult.R
\name{tmult}
\alias{tmult}
\title{Tensor multiplication}
\usage{
tmult(x, y, tform)
}
\arguments{
\item{x, }{a 3-mode S3 tensor class object}

\item{y, }{a 3-mode S3 tensor class object}

\item{tform, }{Any discrete transform.

fft: Fast Fourier Transform

dwt: Discrete Wavelet Transform (Haar Wavelet)

dct: Discrete Cosine transform

dst: Discrete Sine transform

dht: Discrete Hadley transform

dwht: Discrete Walsh-Hadamard transform}
}
\value{
S3 tensor object
}
\description{
Performs the tensor product of two 3D tensors using any discrete transform
}
\examples{
T1 <- t_rand(modes=c(2,2,4))
T2 <- t_rand(modes=c(2,3,4))
print(tmult(T1,T2,"dst"))
}
\references{
M. E. Kilmer, C. D. Martin, and L. Perrone, “A third-order generalization of the matrix svd as a product of third-order tensors,” Tufts University, Department of Computer Science, Tech. Rep. TR-2008-4, 2008

K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
