% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGen.R
\name{rGamma}
\alias{rGamma}
\title{Simulation from the Gamma Distribution}
\usage{
rGamma(n, a = 1, l = 1, p = 0)
}
\arguments{
\item{n}{Sample size.}

\item{a}{Shape.}

\item{l}{Rate.}

\item{p}{Expected censoring proportion.}
}
\value{
A data.frame including the observation times and status indicators.
}
\description{
Generates gamma event times with shape parameter \eqn{\alpha} and rate
parameter \eqn{\lambda}. See \code{\link{fit.Gamma}} for the parameterization. If
a censoring proportion \eqn{p} is provided, the event times are subject to
non-informative random right censoring.
}
\examples{
# Gamma event times with shape 2 and rate 2
# Expected censoring proportion of 20\%
D = rGamma(n=1e3,a=2,l=2,p=0.2);
}
