% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\name{timeDrawOptions}
\alias{timeDrawOptions}
\title{Options for Drawing Times on the Map}
\usage{
timeDrawOptions(palette = "viridis", type = "numeric",
  maxTime = 1800, reverse = FALSE, bins = c(600, 1200),
  legend = TRUE, legendOptions = timeLegendOptions(), radius = 10,
  stroke = TRUE, weight = 3, color = "black", opacity = 0.5,
  fill = TRUE, fillOpacity = 0.5)
}
\arguments{
\item{palette}{A colour palette name e.g. "viridis"}

\item{type}{Either "numeric" or "bin"}

\item{maxTime}{The max time to allow for}

\item{reverse}{Whether to reverse the colour palette.}

\item{bins}{A number of bins or a vector of cut points (only used for the bin palette)}

\item{legend}{Whether to automatically add a legend.}

\item{legendOptions}{A \code{timeLegendOptions} object.}

\item{radius}{The marker radius.}

\item{stroke}{Whether to draw the marker border.}

\item{weight}{Stroke width in pixels.}

\item{color}{Stroke colour.}

\item{opacity}{Stroke opacity.}

\item{fill}{Whether to fill the polygons in with colour.}

\item{fillOpacity}{The fill opacity.}
}
\value{
A list of options governing how time markers are drawn on the map
}
\description{
Options for Drawing Times on the Map
}
\examples{
# show the list
timeDrawOptions()

}
