\name{DonchianChannel}
\alias{Donchian}
\alias{DonchianChannel}
\title{Donchian Channel}
\usage{
  DonchianChannel(HL, n = 10, include.lag = FALSE)
}
\arguments{
  \item{HL}{Object that is coercible to xts or matrix and
  contains High-Low prices.}

  \item{n}{Number of periods for moving average.}

  \item{include.lag}{Should values be lagged so that
  today's prices are not included in the calculation? See
  Note.}
}
\value{
  A object of the same class as \code{HL} or a matrix (if
  \code{try.xts} fails) containing the columns: \describe{
  \item{ high }{ The highest high series. } \item{ mid }{
  The average of \code{high} and \code{low}. } \item{ low
  }{ The lowest low series. } }
}
\description{
  Donchian Channels were created by Richard Donchian and
  were used to generate buy and sell signals for the Turtle
  Trading system.
}
\details{
  Donchian Channels consist of two (sometimes three) lines:

  The top line is the highest high of the past \code{n}
  periods.  The bottom line is the lowest low of the past
  \code{n} periods.  The middle line is the average of the
  top and bottom lines.
}
\note{
  The default of \code{include.lag=FALSE} makes
  \code{DonchainChannel} consistent with other \pkg{TTR}
  functions, in that it includes the current period in the
  calculation.

  The default is different than the original calculation,
  which would calculate the indicator using periods t-1
  through t-n. Setting \code{include.lag=TRUE} will return
  the result of the original calculation.

  The default of this argument may change in the future.
}
\examples{
data(ttrc)
dc <- DonchianChannel( ttrc[,c("High","Low")] )
}
\author{
  Joshua Ulrich
}
\references{
  The following site(s) were used to code/document this
  indicator:\cr
  \url{http://www.linnsoft.com/tour/techind/donch.htm}\cr
}
\seealso{
  See \code{\link{BBands}}.
}
\keyword{ts}

