% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pacf_ly.R
\name{pacf_ly}
\alias{pacf_ly}
\title{A Visualization Function of the PACF Estimation}
\usage{
pacf_ly(ts.obj, lag.max = NULL, ci = 0.95)
}
\arguments{
\item{ts.obj}{a univariate or multivariate time series object of class "ts", "mts", "zoo" or "xts"}

\item{lag.max}{maximum lag at which to calculate the acf. Default is 10*log10(N/m) where N is the number of observations and m the number of series. Will be automatically limited to one less than the number of observations in the series.}

\item{ci}{the significant level of the estimation - a numeric value between 0 and 1, default is set for 0.95}
}
\description{
A Visualization Function of the PACF Estimation
}
\examples{
pacf_ly(AirPassengers, lag.max = 60)
}
