% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segRESTREND.R
\name{seg.RESTREND}
\alias{seg.RESTREND}
\title{Segmented RESTREND (RESidual TREND)}
\usage{
seg.RESTREND(anu.VI, acu.RF, VI.index, breakpoint, sig = 0.05)
}
\arguments{
\item{anu.VI}{The annual (Growing season) max VI. Must be a object of class \code{'ts'} without NA's.
if anu.VI=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{acu.RF}{The optimal accumulated rainfall for anu.VI. Must be a object of class \code{'ts'} without
NA's and be of equal length and temporal range to anu.VI. if anu.RF=FALSE, it will be
calculated from ACP.table usingthe \code{\link{AnnualRF.Cal}}}

\item{VI.index}{the index of the CTSR.VI ts that the anu.VI values occur at. Must be the same length
as anu.VI. NOTE. R indexs from 1 rather than 0.
if VI.index=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{breakpoint}{The index of the most significant breakpoint as determined using \code{\link{CHOW}}.}

\item{sig}{Significance of all the functions. defualt sig=0.05}
}
\value{
a list of class TSSRESTREND.
       See \code{\link{TSSRESTREND}} for details. Note. if called seperatly from TSSRESTREND,
       this list will be incomplete.
}
\description{
For ts with a significant breakpoints in the residuals but not in the VPR. Takes annual VI max and it associated
optimal accumulated precipitation and regresses it with a dummy variable that is 0 before the breakpoint and 1
after it
}
\examples{
# brkp can be determined using VPR.BFAST and CHOW.
brkp <-  as.integer(11)
resu <- seg.RESTREND(segRESTREND$max.NDVI, segRESTREND$acc.precip, segRESTREND$index, brkp)
}
\author{
Arden Burrell, arden.burrell@unsw.edu.au
}

