% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RainfallAccumulator.R
\name{rainfall.accumulator}
\alias{rainfall.accumulator}
\title{Rainfall Accumulator}
\usage{
rainfall.accumulator(CTSR.VI, rf.data, max.acp, max.osp)
}
\arguments{
\item{CTSR.VI}{Complete Time Series of Vegetation Index. An object of class \code{'ts'}. Monthly time series of VI values}

\item{rf.data}{Complete Time Series of monthly rainfall. An object of class \code{'ts'}. Must have the same end as CTSR.VI
and be longer that the max acsumuation period and the max offset period plus the start CTSR.VI}

\item{max.acp}{The max accumuation period. Must be an integer > 1.}

\item{max.osp}{The max offset period. Must be an integer >1}
}
\value{
ACP.table
A matrix with ever possible accumuated rainfall combination
}
\description{
Takes the time series of rainfall and resturns a rainfall accumulation table of every possible combination
of the max accumulation period and the max offset period.
}
\examples{
# Define the max accumuulation period
acp <- 12
#Define the max offset period
osp <- 4
rftable <- rainfall.accumulator(segRESTRENDCTSR$cts.NDVI, segRESTRENDctRF$precip, acp, osp)
}

