% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{subset}
\alias{subset}
\alias{subset.tspred}
\title{Subsetting data into training and testing sets}
\usage{
subset(obj, ...)

\method{subset}{tspred}(obj, data = NULL, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{tspred}} defining a particular time series prediction process.}

\item{...}{Other parameters passed to the method \code{\link{preprocess}} of 
object \code{\link{subsetting}} from \code{obj}.}

\item{data}{A list of time series to be transformed.}
}
\value{
An object of class \code{tspred} with updated structure containing
the produced training and testing sets of time series data.
}
\description{
\code{subset} is a generic function for subsetting time series data 
into training and testing sets. The function invokes particular \emph{methods} which
depend on the class of the first argument.
}
\details{
The function \code{\link{subset.tspred}} calls the method \code{\link{preprocess}} 
on the \code{\link{subsetting}} object from \code{obj}. The produced training and 
testing sets of time series data are introduced in the structure 
of the \code{\link{tspred}} class object in \code{obj}.
}
\examples{
data(CATS)

#Obtaining objects of the processing class
proc1 <- subsetting(test_len=20)
proc2 <- BoxCoxT(lambda=NULL)

#Obtaining objects of the modeling class
modl1 <- ARIMA()

#Obtaining objects of the evaluating class
eval1 <- MSE_eval()

#Defining a time series prediction process
tspred_1 <- tspred(subsetting=proc1,
                   processing=list(BCT=proc2), 
                   modeling=modl1,
                   evaluating=list(MSE=eval1)
)
summary(tspred_1)

tspred_1_subset <- subset(tspred_1, data=CATS[3])

}
\seealso{
[tspred()] for defining a particular time series prediction process,
and [subsetting()] for defining a time series subsetting transformation.

Other preprocess: 
\code{\link{postprocess.tspred}()},
\code{\link{preprocess.tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{preprocess}
\keyword{postprocessing}
\keyword{preprocessing}
\keyword{subsetting}
\keyword{tspred}
