% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{trainModel.MultiWaveAnalysis}
\alias{trainModel.MultiWaveAnalysis}
\title{Generates a discriminant model from an already generated "MultiWaveAnalysis".}
\usage{
\method{trainModel}{MultiWaveAnalysis}(data, labels, method, ...)
}
\arguments{
\item{data}{A MultiWaveAnalysis object obtained with MultiWaveAnalysis function}

\item{labels}{Labeled vector that classify the observations.}

\item{method}{Selected method for discrimination. Valid options are
"linear" and "quadratic"}

\item{...}{Additional arguments}
}
\value{
A discriminant model based on selected method. It can be an object of
the class lda or qda.
}
\description{
Generates a discriminant model from an already generated "MultiWaveAnalysis".
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample, "d6", features = c("Var"))
MWADiscrim <- StepDiscrim(MWA, c(rep(1, 5), rep(2, 5)), 5,
  features = c("Var")
)
model <- trainModel(MWADiscrim, c(rep(1, 5), rep(2, 5)), "linear")
}

}
\seealso{
\itemize{
\item \code{\link{MultiWaveAnalysis}}
\item \code{\link{StepDiscrim}}
\item \code{\link{StepDiscrimV}}
}
}
