% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSamp.R
\name{tSamp}
\alias{tSamp}
\title{Trait Values Sampling}
\usage{
tSamp(TPDc = NULL, TPDs = NULL, size = 1)
}
\arguments{
\item{TPDc}{An object of class "TPDcomm", generated with the \code{\link{TPDc}} function, containing the TPDc of the considered communities.}

\item{TPDs}{An object of class "TPDsp", generated with the \code{\link{TPDs}} function, containing the TPDs of the considered populations or species.}

\item{size}{Non-negative integer giving the number of observations to choose. Defaults to 1.}
}
\value{
\code{tSamp} returns a list containing sampled trait values for each community of TPDc or species/populations from TPDs.
 @examples
# 1.  Compute the TPDs of three different species
traits_iris <- iris[, c("Sepal.Length", "Sepal.Width")]
sp_iris <- iris$Species
example_TPDs <- TPDs(species = sp_iris, traits = traits_iris)

#2. Three different communities with different abundances of each species
example_abundances <- matrix(c(c(0.5, 0.3, 0.2,
                                 0.1, 0.8, 0.1,
                                 0.5, 0,   0.5)), #I. virg. dominates; setosa absent
                         ncol = 3, byrow = TRUE, dimnames = list(paste0("Comm.",1:3),
                         unique(iris$Species)))
example_TPDc <- TPDc (TPDs = example_TPDs, sampUnit = example_abundances)

#3. Sample 1,000 trait values from each species and community
example_sampling <- tSamp(TPDc = example_TPDc, TPDs = example_TPDs,
                                 size = 1000)
}
\description{
\code{tSamp} samples (with replacement) trait values from populations, species or communities. The probability of sampling each trait --or combination of traits in multidimensional cases-- is proportional to the value of TPDs or TPDc for the corresponding cell (the trait space is divided in a grid composed of cells, see \code{\link{TPDs}} for further information).
}
