% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Volcano plot for visualizing differentailly expressed genes.}
\usage{
volcano_plot(
  data,
  title = "CT-vs-LT12",
  log2fc_cutoff = 1,
  pq_value = "pvalue",
  pq_cutoff = 0.05,
  cutoff_line = "longdash",
  point_shape = "large_circle",
  point_size = 2,
  point_alpha = 0.5,
  color_normal = "#888888",
  color_log2fc = "#008000",
  color_pvalue = "#0088ee",
  color_Log2fc_p = "#ff0000",
  label_size = 3,
  boxed_labels = FALSE,
  draw_connectors = FALSE,
  legend_pos = "right"
)
}
\arguments{
\item{data}{Dataframe: differentially expressed genes (DEGs) stats (1st-col: Genes, 2nd-col: log2FoldChange, 3rd-col: Pvalue, 4th-col: FDR).}

\item{title}{Character: title of plot. Default: CT-vs-LT12.}

\item{log2fc_cutoff}{Numeric: log2(FoldChange) cutoff log2(2) = 1. Default: 1.0, min: 0.0, max: null.}

\item{pq_value}{Character: select pvalue or qvalue. Default: "pvalue", options: "pvalue", "padj".}

\item{pq_cutoff}{Numeric: pvalue or qvalue cutoff. Default: 0.005, min: 0.000, max: 1.000.}

\item{cutoff_line}{Character: cutoff line type. Default: "longdash", options: "blank", "solid", "dashed", "dotted", "dotdash", "longdash", "twodash".}

\item{point_shape}{Character: point shape. Default: "large_circle", options: "border_square", "border_circle", "border_triangle", "plus", "times", "border_diamond", "border_triangle_down", "square_times", "plus_times", "diamond_plus", "circle_plus", "di_triangle", "square_plus", "circle_times","square_triangle", "fill_square", "fill_circle", "fill_triangle", "fill_diamond", "large_circle", "small_circle", "fill_border_circle", "fill_border_square", "fill_border_diamond", "fill_border_triangle".}

\item{point_size}{Numeric: point size. Default: 1.0, min: 0.0, max: null.}

\item{point_alpha}{Numeric: point color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{color_normal}{Character: normal genes color (color name or hex value). Default: "#888888".}

\item{color_log2fc}{Character: genes color that log2fc >= log2fc_cutoff. Default: "#008000".}

\item{color_pvalue}{Character: genes color that pvalue > pq_cutoff. Default: "#0088ee".}

\item{color_Log2fc_p}{Character: genes color that log2fc >= log2fc_cutoff and pvalue > pq_cutoff. Default: "#ff0000".}

\item{label_size}{Numeric: DEG labels size. Default: 3.0, min: 0.0, max: null.}

\item{boxed_labels}{Logical: add box to every DEG label. Default: FALSE.}

\item{draw_connectors}{Logical: add connector between DEGs and labels. Default: FALSE.}

\item{legend_pos}{Character: legend position. Default: "right", options: "right", "left", "top", "bottom".}
}
\value{
Plot: volcano plot for visualizing differentailly expressed genes.
}
\description{
Volcano plot for visualizing differentailly expressed genes.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(degs_stats)
head(degs_stats)

# 3. Default parameters
volcano_plot(degs_stats)

# 4. Set color_Log2fc_p = "#ff8800"
volcano_plot(degs_stats, color_Log2fc_p = "#ff8800")

# 5. Set boxed_labels = TRUE
volcano_plot(degs_stats, boxed_labels = TRUE)

}
\author{
benben-miao
}
