% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOSTone.R
\name{TOSTone}
\alias{TOSTone}
\title{TOST function for a one-sample t-test (Cohen's d)}
\usage{
TOSTone(m, mu, sd, n, low_eqbound_d, high_eqbound_d, alpha, plot = TRUE)
}
\arguments{
\item{m}{mean}

\item{mu}{value to compare against}

\item{sd}{standard deviation}

\item{n}{sample size}

\item{low_eqbound_d}{lower equivalence bounds (e.g., -0.5) expressed in standardized mean difference (Cohen's d)}

\item{high_eqbound_d}{upper equivalence bounds (e.g., 0.5) expressed in standardized mean difference (Cohen's d)}

\item{alpha}{alpha level (default = 0.05)}

\item{plot}{set whether results should be plotted (plot = TRUE) or not (plot = FALSE) - defaults to TRUE}
}
\value{
Returns TOST t-value 1, TOST p-value 1, TOST t-value 2, TOST p-value 2, degrees of freedom, low equivalence bound, high equivalence bound, Lower limit confidence interval TOST, Upper limit confidence interval TOST
}
\description{
TOST function for a one-sample t-test (Cohen's d)
}
\examples{
## Test observed mean of 0.54 and standard deviation of 1.2 in sample of 100 participants
## against 0.5 given equivalence bounds of Cohen's d = -0.3 and 0.3, with an alpha = 0.05.
TOSTone(m=0.54,mu=0.5,sd=1.2,n=100,low_eqbound_d=-0.3, high_eqbound_d=0.3, alpha=0.05)
}
