% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS.R
\name{TNRS}
\alias{TNRS}
\title{Resolve plant taxonomic names}
\usage{
TNRS(
  taxonomic_names,
  sources = c("tropicos", "wcvp"),
  classification = "tropicos",
  mode = "resolve",
  matches = "best",
  accuracy = NULL,
  skip_internet_check = FALSE,
  ...
)
}
\arguments{
\item{taxonomic_names}{Data.frame containing two columns: 1) Row number, 2) Taxonomic names to be resolved (or parsed).  Alternatively, a character vector of names can be supplied.}

\item{sources}{Character vector. Taxonomic sources to use. Default is c("tropicos","wcvp"). Options include "tropicos", "usda", "wfo", and "wcvp".}

\item{classification}{Character. Family classification to use. Currently options include "tropicos" (the default), which is equivalent to APGIII, and "wfo".}

\item{mode}{Character.  Options are "resolve" and "parse". Default option is "resolve"}

\item{matches}{Character. Should all matches be returned ("all") or only the best match ("best", the default)?}

\item{accuracy}{numeric.  If specified, only matches with a score greater than or equal to the supplied accuracy level will be returned. If left NULL, the default threshold will be used.}

\item{skip_internet_check}{Should the check for internet connectivity be skipped? Default is FALSE.}

\item{...}{Additional parameters passed to internal functions}
}
\value{
Dataframe containing TNRS results.
}
\description{
Resolve plant taxonomic names.
}
\note{
usda = United States Department of Agriculture, wfo = World Flora Online, wcvp = World Checklist of Vascular Plants.

For queries of more than 5000 names, the function will automatically divide the query into batches of 5000 names and then run the batches one after the other. Thus, for very large queries this may take some time. When this is the case, a progress bar will be displayed.

IMPORTANT: Note that parallelization of queries is automatically handled by the API, and so there is no need to further parallelize in R (in fact, doing so may actually slow things down!).
}
\examples{
\dontrun{
# Take a subset of the testfile to speed up runtime
tnrs_testfile <- tnrs_testfile[1:20, ]

results <- TNRS(taxonomic_names = tnrs_testfile)

# Inspect the results
head(results, 10)
}

}
