% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS.R
\name{TNRS}
\alias{TNRS}
\title{Resolve plant taxonomic names}
\usage{
TNRS(
  taxonomic_names,
  sources = "tpl,tropicos,usda",
  classification = "tropicos",
  mode = "resolve",
  matches = "best"
)
}
\arguments{
\item{taxonomic_names}{Data.frame containing two columns: 1) Row number, 2) Taxonomic names to be resolved (or parsed).  Alternatively, a character vector of names can be supplied.}

\item{sources}{Character. Taxonomic sources to use. Default is "tpl,tropicos,usda". Options include tpl,tropicos,usda,ncbi}

\item{classification}{Character. Family classification to use. Currently the only options is "tropicos", which is equivalent to APGIII.}

\item{mode}{Character.  Options are "resolve" and "parse". Default option is "resolve"}

\item{matches}{Character. Should all matches be returned ("all") or only the best match ("best", the default)?}
}
\value{
Dataframe containing TNRS results.
}
\description{
Resolve plant taxonomic names.
}
\examples{
{
#Take a subset of the testfile to speed up runtime                  
tnrs_testfile <- tnrs_testfile[1:20,]
 
results <- TNRS(taxonomic_names = tnrs_testfile)
  
# Inspect the results
head(results, 10)
}

}
