% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{save_image_series}
\alias{save_image_series}
\title{Save a series of DICOM image files as a zip file}
\usage{
save_image_series(series_instance_uid, out_dir, out_file_name = NULL)
}
\arguments{
\item{series_instance_uid}{Series instance UID. To get a list of available series instance UIDs, call \code{\link{get_series_info}}.
Note: if \code{series_instance_uid} is invalid, the API may still successfully return an empty zip file.}

\item{out_dir}{Directory to write zip file to}

\item{out_file_name}{Name of zip file to write. If \code{out_file_name} is \code{NULL}, the original file name will be used.}
}
\value{
List containing elements:
\itemize{
  \item \code{out_file}: The output zip file that was written
  \item \code{response}: API response
}
}
\description{
Save a series of DICOM image files as a zip file
}
\examples{
\dontrun{
save_image_series(
     series_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.806935685832642465081499816867",
     out_dir = "~/Desktop")
save_image_series(
     series_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.806935685832642465081499816867",
     out_dir = "~/Desktop", out_file_name = "file.zip")
}

}
\seealso{
\code{\link{get_series_info}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
