\name{hypoData}
\docType{data}
\alias{hypoData}
\title{A simulation dataset for comparing two-group tag count
 data, focusing on RNA-seq}
\description{
A simulation dataset, consisting of 1,000 rows (or genes) and
 6 columns (or independent biological samples).
}
\usage{data(hypoData)}
\format{hypoData is a matrix of dimension 1,000 times 6.}
\details{
This package typically start the differential expression analysis with
 a count table matrix such as hypoData where each row indicates the
 gene (or transcript), each column indicates the sample (or library),
 and each cell indicates the number of counts to the gene in the sample.
 The first three columns are produced from biological replicates of,
 for example, Group 1 and the remaining columns are from Group 2;
 i.e., {G1_rep1, G1_rep2, G1_rep3} vs. {G2_rep1, G2_rep2, G2_rep3}.
This data is generated by the \code{\link{simulateReadCounts}}
 function with default parameter settings. The first 200 genes are
 differentially expressed in the two groups. Of these, the first 180
 genes are expressed at a higher level in Group 1 (G1) and the remaining
 20 genes are expressed at a higher level in G2. Accordingly, the
 201-1000th genes are not differentially expressed (non-DEGs).
 The levels of differential expression (DE) are four-fold in both groups. 
} 
\examples{
\dontrun{
# The 'hypoData' was generated by following commands.
tcc <- simulateReadCounts(Ngene = 1000, PDEG = 0.2,
                              DEG.assign = c(0.9, 0.1),
                              DEG.foldchange = c(4, 4),
                              replicates = c(3, 3))
hypoData <- tcc$count
}
}
\keyword{datasets}
