% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_BinCont_copula.R
\name{sample_deltas_BinCont}
\alias{sample_deltas_BinCont}
\title{Sample individual casual treatment effects from given D-vine copula model in
binary continuous setting}
\usage{
sample_deltas_BinCont(
  copula_par,
  rotation_par,
  copula_family1,
  copula_family2 = copula_family1,
  n,
  q_S0 = NULL,
  q_S1 = NULL,
  q_T0 = NULL,
  q_T1 = NULL,
  marginal_sp_rho = TRUE,
  setting = "BinCont",
  composite = FALSE,
  plot_deltas = FALSE,
  restr_time = +Inf
)
}
\arguments{
\item{copula_par}{Parameter vector for the sequence of bivariate copulas that
define the D-vine copula. The elements of \code{copula_par} correspond to
\eqn{(c_{12}, c_{23}, c_{34}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{rotation_par}{Vector of rotation parameters for the sequence of
bivariate copulas that define the D-vine copula. The elements of
\code{rotation_par} correspond to \eqn{(c_{12}, c_{23}, c_{34}, c_{13;2},
  c_{24;3}, c_{14;23})}.}

\item{copula_family1}{Copula family of \eqn{c_{12}} and \eqn{c_{34}}. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family} correspond to \eqn{(c_{12}, c_{34})}.}

\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family2} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{n}{Number of samples to be taken from the D-vine copula.}

\item{q_S0}{Quantile function for the distribution of \eqn{S_0}.}

\item{q_S1}{Quantile function for the distribution of \eqn{S_1}.}

\item{q_T0}{Quantile function for the distribution of \eqn{T_0}. This should be
\code{NULL} if \eqn{T_0} is binary.}

\item{q_T1}{Quantile function for the distribution of \eqn{T_1}. This should be
\code{NULL} if \eqn{T_1} is binary.}

\item{marginal_sp_rho}{(boolean) Compute the sample Spearman correlation
matrix? Defaults to \code{TRUE}.}

\item{setting}{Should be one of the following two:
\itemize{
\item \code{"BinCont"}: for when \eqn{S} is continuous and \eqn{T} is binary.
\item \code{"SurvSurv"}: for when both \eqn{S} and \eqn{T} are time-to-event variables.
}}

\item{composite}{(boolean)  If \code{composite} is \code{TRUE}, then the surrogate
endpoint is a composite of both a "pure" surrogate endpoint and the true
endpoint, e.g., progression-free survival is the minimum of time-to-progression
and time-to-death.}

\item{plot_deltas}{Plot the sampled individual causal effects? Defaults to
\code{FALSE}.}

\item{restr_time}{Restriction time for the potential outcomes. Defaults to
\code{+Inf} which means no restriction. Otherwise, the sampled potential outcomes
are replace by \code{pmin(S0, restr_time)} (and similarly for the other potential
outcomes).}
}
\value{
A list with two elements:
\itemize{
\item \code{Delta_dataframe}: a dataframe containing the sampled individual causal
treatment effects
\item \code{marginal_sp_rho_matrix}: a matrix containing the marginal pairwise Spearman's rho
parameters estimated from the sample. If \code{marginal_sp_rho = FALSE}, this
matrix is not computed and \code{NULL} is returned for this element of the list.
}
}
\description{
Sample individual casual treatment effects from given D-vine copula model in
binary continuous setting
}
