% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ple.R
\name{plot_ple}
\alias{plot_ple}
\title{Patient-Level Estimate Plot (plot_ple): Visualize distribution of estimates}
\usage{
plot_ple(object, target = NULL, type = "waterfall", ...)
}
\arguments{
\item{object}{\code{ple_train} object}

\item{target}{Which patient-level estimate to visualize. Default=NULL, which uses 
the estimated treatment difference.}

\item{type}{TYpe of plot. Default="waterfall"; type="density" shows density plot.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Plot (ggplot2) object
}
\description{
Plots based on Patient-level estimate (see \code{ple_train}) model results. Options 
include "waterfall" and "density". Target controls which column of "mu_train" 
(from ple_train object) is shown on the plot.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A


mod1 = ple_train(Y=Y, A=A, X=X, Xtest=X, ple="ranger", meta="X-learner")
plot_ple(mod1)
}

}
