% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/histogramDistance.R
\name{histogramDistance}
\alias{histogramDistance}
\title{Plot two StochKit2R simulation histograms and display distance}
\usage{
histogramDistance(histogramFileName1, histogramFileName2)
}
\arguments{
\item{histogramFileName1}{Character string with path to StochKit2 histogram output file. IMPORTANT: histogram file names have format hist_<species index>_<time point>.dat, where species index STARTS AT 0 (not 1!)}

\item{histogramFileName2}{Character string with path to StochKit2 histogram output file. IMPORTANT: histogram file names have format hist_<species index>_<time point>.dat, where species index STARTS AT 0 (not 1!)}
}
\value{
The ggplot object
}
\description{
\code{histogramDistance} Plots histograms of data stored in StochKit2R histogram output files \code{histogramFileName1} and \code{histogramFileName1} and calculates histogram distance. IMPORTANT: histogram file names have format hist_<species index>_<time point>.dat, where species index STARTS AT 0 (not 1!)
}
\examples{
\dontrun{
#example using included dimer_decay.xml file
model <- system.file("dimer_decay.xml",package="StochKit2R")
#output written to ex_out directory (created in current working directory)
ssa(model,"ex_out",10,100,20,keepHistograms=TRUE,force=TRUE)

#another ensemble with output written to ex_out2 directory
ssa(model,"ex_out2",10,100,20,keepHistograms=TRUE,force=TRUE)
#plot the histograms for species 2 at time point 5 for the two runs above
#IMPORTANT: histogram file names have format:
#hist_<species index>_<time point>.dat, where species index STARTS AT 0
histogramDistance("ex_out/histograms/hist_1_5.dat",
                 "ex_out2/histograms/hist_1_5.dat")
}
}

