% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochBlockKMint.R
\name{stochBlockKMint}
\alias{stochBlockKMint}
\title{A function for using k-means to initialized the  stochastic one-mode and linked blockmodeling.}
\usage{
stochBlockKMint(
  M,
  k,
  nstart = 100,
  perm = 0,
  sharePerm = 0.2,
  save.initial.param = TRUE,
  deleteMs = TRUE,
  max.iden = 10,
  return.all = FALSE,
  return.err = TRUE,
  seed = NULL,
  maxTriesToFindNewPar = perm * 10,
  skip.par = NULL,
  printRep = ifelse(perm <= 10, 1, round(perm/10)),
  n = NULL,
  nCores = 1,
  useParLapply = FALSE,
  cl = NULL,
  stopcl = is.null(cl),
  ...
)
}
\arguments{
\item{M}{A square matrix giving the adjaciency relationg between the network's nodes (aka vertexes)}

\item{k}{The number of clusters used in the generation of partitions.}

\item{nstart}{number of random starting points for the classical k-means algorithm (for each set of units). Defaults to \code{100}.}

\item{perm}{Number or partitions obtained by randomly permuting the k-means partition - if 0, no permutations are made, only the original partition is analyzed.}

\item{sharePerm}{The probability that a unit will have their randomly assigned. Defaults to \code{0.20}.}

\item{save.initial.param}{Should the inital parameters(\code{approaches}, ...) of using \code{stochBlock} be saved. The default value is \code{TRUE}.}

\item{deleteMs}{Delete networks/matrices from the results of to save space. Defaults to \code{TRUE}.}

\item{max.iden}{Maximum number of results that should be saved (in case there are more than \code{max.iden} results with minimal error, only the first \code{max.iden} will be saved).}

\item{return.all}{If \code{FALSE}, solution for only the best (one or more) partition/s is/are returned.}

\item{return.err}{Should the error for each optimized partition be returned. Defaults to \code{TRUE}.}

\item{seed}{Optional. The seed for random generation of partitions.}

\item{maxTriesToFindNewPar}{The maximum number of partition try when trying to find a new partition to optimize that was not yet checked before - the default value is \code{rep * 1000}.}

\item{skip.par}{The partitions that are not allowed or were already checked and should therefore be skipped.}

\item{printRep}{Should some information about each optimization be printed.}

\item{n}{The number of units by "modes". It is used only for generating random partitions. It has to be set only if there are more than two modes or if there are two modes, but the matrix representing the network is one mode (both modes are in rows and columns).}

\item{nCores}{Number of cores to be used. Value \code{0} means all available cores. It can also be a cluster object.}

\item{useParLapply}{Should \code{parLapplyLB} be used (otherwise \code{foreach} is used). Defaults to true as it needs less dependencies. It might be removed in future releases and only allow the use of parLapplyLB.}

\item{cl}{The cluster to use (if formed beforehand). Defaults to \code{NULL}.}

\item{stopcl}{Should the cluster be stopped after the function finishes. Defaults to \code{is.null(cl)}.}

\item{...}{Arguments passed to other functions, see \code{\link{stochBlock}}.}
}
\value{
A list containing:
 \item{M}{The one- or multi-mode matrix of the network analyzed}
  \item{res}{If \code{return.all = TRUE} - A list of results the same as \code{best} - one \code{best} for each partition optimized.}
  \item{best}{A list of results from \code{stochblock}, only without \code{M}.}
  \item{err}{If \code{return.err = TRUE} - The vector of errors or inconsistencies of the empirical  network with the ideal partitions.}
  \item{nIter}{The vector of the iterations on each starting partition. If many of the values equal\code{maxiter}, then  \code{maxiter} may be too small.}
  \item{checked.par}{If selected - A list of checked partitions. If \code{merge.save.skip.par} is \code{TRUE}, this list also includes the partitions in \code{skip.par}.}
  \item{call}{The call to this function.}
  \item{initial.param}{If selected - The initial parameters are used.}
}
\description{
A function for using k-means to initialized the  stochastic one-mode and linked blockmodeling.
}
\references{
Škulj, D., & Žiberna, A. (2022). Stochastic blockmodeling of linked networks. Social Networks, 70, 240-252.
}
\author{
\enc{Aleš, Žiberna}{Ales Ziberna}
}
