% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk.R
\name{generate_st_samples}
\alias{generate_st_samples}
\title{Select terminals}
\usage{
generate_st_samples(graph, ter_number, prob)
}
\arguments{
\item{graph}{an igraph graph; should be undirected, otherwise it is converted to undirected.}

\item{ter_number}{a numeric vector; each element indicates the number of terminals to be selected and length of vector
indicates the number of terminal sets to be picked.}

\item{prob}{a numeric vector of the same length as ter_number; prob[i] defines a probability with which each
next node accepted or rejected while selecting ter_number[i] terminals.}
}
\value{
A list of the same length as ter_number. Each element of list contains a vector of ids of selected vertices.
}
\description{
Provides random walk procedure. Starting from the randomly selected node, choose a neighbour node uniformly
             randomly, until given number of terminals won't be found.
}
\examples{
generate_st_samples(graph = graph("Zachary"),
                    ter_number = c(3, 4),
                    prob = c(0.1, 0.2))

}
\references{
1. Afshin Sadeghi and Holger Froehlich, "Steiner tree methods for optimal sub-network
               identification: an empirical study", BMC Bioinformatics 2013 14:144
}
