% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rmdupobs.R
\name{rmdupobs}
\alias{rmdupobs}
\title{Remove duplicate observations from data}
\usage{
rmdupobs(data)
}
\arguments{
\item{data}{a data.frame or data.table}
}
\value{
a \code{data} of same class as input with only unique observations
}
\description{
Takes in a data, and returns it with duplicate observations removed
}
\details{
Duplicate observations are redundant and they need to be removed from the data.
 \code{rmdupobs} does just that; it removes the duplicated observations (the ones
 in which value of every variable is duplicated) and returns the data with only
 unique observations.

 It works for both 'data.frame' and 'data.table' and returns the \code{data} with
 same class as that of input.
}
\examples{
# A 'data.frame'
df <- data.frame(x = c(1, 2, 5, 1), y = c(3, 3, 1, 3))

# Remove duplicate observations from data
dfUnq <- rmdupobs(data = df)
}
\author{
Akash Jain
}
\seealso{
\code{\link{randomise}}, \code{\link{rmdupkey}}, \code{\link{factorise}}
}

