% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/factorise.R
\name{factorise}
\alias{factorise}
\title{Change the class of variables to factor}
\usage{
factorise(data, colNames)
}
\arguments{
\item{data}{a data.frame or data.table}

\item{colNames}{a character vector of variable names to be converted to factor}
}
\value{
\code{data} of same class as input with specified variables converted to factor
}
\description{
Takes in data and colNames, and returns the data with all variables mentioned in
 colNames converted to factor
}
\details{
We often face the task of converting a bunch of variables to factor. This
 function is particularly useful in such a situation. Just specify the \code{data}
 and variable names and all of them will be converted to factor.

 It works for both 'data.frame' and 'data.table', and the output is data of the same
 class as that of input.
}
\examples{
# A 'data.frame'
df <- data.frame(x = c(1, 2, 3, 4, 5),
                 y = c('a', 'b', 'c', 'd', 'e'),
                 z = c(1, 1, 0, 0, 1))

# Change the class of variables y and z to factors
dfFac <- factorise(data = df, colNames = c('y', 'z'))
}
\author{
Akash Jain
}
\seealso{
\code{\link{randomise}}, \code{\link{rmdupkey}}, \code{\link{rmdupobs}}
}

